/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.bci.IndyPluginClassLoaderFactory;
import co.elastic.apm.agent.bci.classloading.ExternalPluginClassLoader;
import co.elastic.apm.agent.common.JvmRuntimeInfo;
import co.elastic.apm.agent.sdk.state.GlobalState;
import co.elastic.apm.agent.util.PackageScanner;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stagemonitor.configuration.ConfigurationOptionProvider;
import org.stagemonitor.util.IOUtils;

public class IndyBootstrap {
    private static final String INDY_BOOTSTRAP_CLASS_NAME = "java.lang.IndyBootstrapDispatcher";
    private static final String INDY_BOOTSTRAP_RESOURCE = "bootstrap/java/lang/IndyBootstrapDispatcher.esclazz";
    private static final String INDY_BOOTSTRAP_MODULE_SETTER_CLASS_NAME = "co.elastic.apm.agent.modulesetter.ModuleSetter";
    private static final String INDY_BOOTSTRAP_MODULE_SETTER_RESOURCE = "bootstrap/co/elastic/apm/agent/modulesetter/ModuleSetter.esclazz";
    public static final String LOOKUP_EXPOSER_CLASS_NAME = "co.elastic.apm.agent.bci.classloading.LookupExposer";
    private static final String EMBEDDED_PLUGINS_PACKAGE_PREFIX = "co.elastic.apm.agent.";
    private static final ConcurrentMap<String, List<String>> classesByPackage = new ConcurrentHashMap<String, List<String>>();
    @Nullable
    static Method indyBootstrapMethod;

    public static Method getIndyBootstrapMethod(Logger logger) {
        if (indyBootstrapMethod != null) {
            return indyBootstrapMethod;
        }
        try {
            Class<?> indyBootstrapClass = IndyBootstrap.initIndyBootstrap(logger);
            indyBootstrapClass.getField("bootstrap").set(null, IndyBootstrap.class.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class));
            indyBootstrapMethod = indyBootstrapClass.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
            return indyBootstrapMethod;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> initIndyBootstrap(Logger logger) throws Exception {
        Class<?> indyBootstrapDispatcherClass = IndyBootstrap.loadClassInBootstrap(INDY_BOOTSTRAP_CLASS_NAME, INDY_BOOTSTRAP_RESOURCE);
        if (JvmRuntimeInfo.ofCurrentVM().getMajorVersion() >= 9 && JvmRuntimeInfo.ofCurrentVM().isJ9VM()) {
            try {
                logger.info("Overriding IndyBootstrapDispatcher class's module to java.base module. This is required in J9 VMs.");
                IndyBootstrap.setJavaBaseModule(indyBootstrapDispatcherClass);
            }
            catch (Throwable throwable) {
                logger.warn("Failed to setup proper module for the IndyBootstrapDispatcher class, instrumentation may fail", throwable);
            }
        }
        return indyBootstrapDispatcherClass;
    }

    private static Class<?> loadClassInBootstrap(String className, String resourceName) throws IOException, ClassNotFoundException {
        Class<?> bootstrapClass;
        try {
            bootstrapClass = Class.forName(className, false, null);
        }
        catch (ClassNotFoundException e) {
            byte[] classBytes = IOUtils.readToBytes(ElasticApmAgent.getAgentClassLoader().getResourceAsStream(resourceName));
            if (classBytes == null || classBytes.length == 0) {
                throw new IllegalStateException("Could not locate " + resourceName);
            }
            ClassInjector.UsingUnsafe.ofBootLoader().injectRaw(Collections.singletonMap(className, classBytes));
            bootstrapClass = Class.forName(className, false, null);
        }
        return bootstrapClass;
    }

    static void setJavaBaseModule(Class<?> targetClass) throws Throwable {
        Class<?> moduleSetterClass = IndyBootstrap.loadClassInBootstrap(INDY_BOOTSTRAP_MODULE_SETTER_CLASS_NAME, INDY_BOOTSTRAP_MODULE_SETTER_RESOURCE);
        MethodHandles.lookup().findStatic(moduleSetterClass, "setJavaBaseModule", MethodType.methodType(Void.TYPE, Class.class)).invoke(targetClass);
    }

    @Nullable
    public static ConstantCallSite bootstrap(MethodHandles.Lookup lookup, String adviceMethodName, MethodType adviceMethodType, Object ... args) {
        try {
            ClassFileLocator classFileLocator;
            String adviceClassName = (String)args[0];
            int enter = (Integer)args[1];
            Class instrumentedType = (Class)args[2];
            String instrumentedMethodName = (String)args[3];
            MethodHandle instrumentedMethod = args.length >= 5 ? (MethodHandle)args[4] : null;
            ClassLoader instrumentationClassLoader = ElasticApmAgent.getInstrumentationClassLoader(adviceClassName);
            ArrayList<String> pluginClasses = new ArrayList<String>();
            if (instrumentationClassLoader instanceof ExternalPluginClassLoader) {
                pluginClasses.addAll(((ExternalPluginClassLoader)instrumentationClassLoader).getClassNames());
                File agentJarFile = ElasticApmAgent.getAgentJarFile();
                if (agentJarFile == null) {
                    throw new IllegalStateException("External plugin cannot be applied - can't find agent jar");
                }
                classFileLocator = new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(instrumentationClassLoader), ClassFileLocator.ForJarFile.of(agentJarFile));
            } else {
                pluginClasses.addAll(IndyBootstrap.getClassNamesFromBundledPlugin(adviceClassName, instrumentationClassLoader));
                classFileLocator = ClassFileLocator.ForClassLoader.of(instrumentationClassLoader);
            }
            pluginClasses.add(LOOKUP_EXPOSER_CLASS_NAME);
            ClassLoader pluginClassLoader = IndyPluginClassLoaderFactory.getOrCreatePluginClassLoader(lookup.lookupClass().getClassLoader(), pluginClasses, instrumentationClassLoader, classFileLocator, ElementMatchers.isAnnotatedWith(ElementMatchers.named(GlobalState.class.getName())).or(ElementMatchers.nameContains("Config").and(ElementMatchers.hasSuperType(ElementMatchers.is(ConfigurationOptionProvider.class)))));
            Class<?> adviceInPluginCL = pluginClassLoader.loadClass(adviceClassName);
            Class<?> lookupExposer = pluginClassLoader.loadClass(LOOKUP_EXPOSER_CLASS_NAME);
            MethodHandles.Lookup indyLookup = (MethodHandles.Lookup)lookupExposer.getMethod("getLookup", new Class[0]).invoke(null, new Object[0]);
            MethodHandle methodHandle = indyLookup.findStatic(adviceInPluginCL, adviceMethodName, adviceMethodType);
            return new ConstantCallSite(methodHandle);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(IndyBootstrap.class).error(e.getMessage(), e);
            return null;
        }
    }

    private static List<String> getClassNamesFromBundledPlugin(String adviceClassName, ClassLoader adviceClassLoader) throws IOException, URISyntaxException {
        if (!adviceClassName.startsWith(EMBEDDED_PLUGINS_PACKAGE_PREFIX)) {
            throw new IllegalArgumentException("invalid advice class location : " + adviceClassName);
        }
        String pluginPackage = adviceClassName.substring(0, adviceClassName.indexOf(46, EMBEDDED_PLUGINS_PACKAGE_PREFIX.length()));
        List<String> pluginClasses = (ArrayList<String>)classesByPackage.get(pluginPackage);
        if (pluginClasses == null) {
            pluginClasses = new ArrayList<String>();
            Collection<String> pluginClassLoaderRootPackages = ElasticApmAgent.getPluginClassLoaderRootPackages(pluginPackage);
            for (String pkg : pluginClassLoaderRootPackages) {
                pluginClasses.addAll(PackageScanner.getClassNames(pkg, adviceClassLoader));
            }
            classesByPackage.putIfAbsent(pluginPackage, pluginClasses);
            pluginClasses = (List)classesByPackage.get(pluginPackage);
        }
        return pluginClasses;
    }
}

