/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.SQSMessageAttributesGetter;
import co.elastic.apm.agent.awslambda.helper.AbstractMessageBasedTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public class SQSTransactionHelper
extends AbstractMessageBasedTransactionHelper<SQSEvent, Void, SQSEvent.SQSMessage> {
    private static final String AWS_MESSAGE_SENT_TIMESTAMP_KEY = "SentTimestamp";
    @Nullable
    private static SQSTransactionHelper INSTANCE;
    private final SQSEvent.SQSMessage placeholderMessage = new SQSEvent.SQSMessage();

    private SQSTransactionHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    public static SQSTransactionHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SQSTransactionHelper(GlobalTracer.requireTracerImpl());
        }
        return INSTANCE;
    }

    @Override
    protected TextHeaderGetter<SQSEvent.SQSMessage> getTextHeaderGetter() {
        return SQSMessageAttributesGetter.INSTANCE;
    }

    @Override
    protected String getAWSService() {
        return "sqs";
    }

    @Override
    @Nullable
    protected String getQueueArn(SQSEvent.SQSMessage record) {
        return record.getEventSourceArn();
    }

    @Override
    protected long getMessageTimestampMs(SQSEvent.SQSMessage record) {
        if (null != record.getMessageAttributes() && record.getMessageAttributes().containsKey(AWS_MESSAGE_SENT_TIMESTAMP_KEY)) {
            try {
                String strValue = this.getHeaderValue(record, AWS_MESSAGE_SENT_TIMESTAMP_KEY);
                return strValue != null ? Long.parseLong(strValue) : -1L;
            }
            catch (Exception e) {
                return -1L;
            }
        }
        return -1L;
    }

    @Override
    protected String getBody(SQSEvent.SQSMessage record) {
        return record.getBody();
    }

    @Override
    protected String getMessageId(SQSEvent.SQSMessage record) {
        return record.getMessageId();
    }

    @Override
    protected String getRegion(SQSEvent.SQSMessage record) {
        return record.getAwsRegion();
    }

    @Override
    protected Collection<String> getHeaderNames(SQSEvent.SQSMessage record) {
        if (null != record.getMessageAttributes()) {
            return record.getMessageAttributes().keySet();
        }
        return Collections.emptySet();
    }

    @Override
    protected String getHeaderValue(SQSEvent.SQSMessage record, String key) {
        if (null != record.getMessageAttributes() && record.getMessageAttributes().containsKey(key)) {
            return ((SQSEvent.MessageAttribute)record.getMessageAttributes().get(key)).getStringValue();
        }
        return null;
    }

    @Override
    protected String getVersion(SQSEvent.SQSMessage record) {
        return null;
    }

    @Override
    protected SQSEvent.SQSMessage getRecord(SQSEvent event) {
        SQSEvent.SQSMessage record = null;
        if (null != event.getRecords() && event.getRecords().size() == 1) {
            record = (SQSEvent.SQSMessage)event.getRecords().get(0);
        }
        return record != null ? record : this.placeholderMessage;
    }
}

