/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.helper.AbstractLambdaTransactionHelper;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.CloudOrigin;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.ServiceOrigin;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import com.amazonaws.services.lambda.runtime.Context;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAPIGatewayTransactionHelper<I, O>
extends AbstractLambdaTransactionHelper<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAPIGatewayTransactionHelper.class);
    protected static final String TRANSACTION_TYPE = "request";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final Set<String> METHODS_WITH_BODY = new HashSet<String>(Arrays.asList("POST", "PUT", "PATCH", "DELETE"));
    private static final String CONTENT_TYPE_FROM_URLENCODED = "application/x-www-form-urlencoded";

    protected AbstractAPIGatewayTransactionHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Nullable
    protected abstract String getHttpMethod(I var1);

    protected abstract String getApiGatewayVersion();

    protected void fillHttpRequestData(Transaction transaction, @Nullable String httpMethod, @Nullable Map<String, String> headers, @Nullable String serverName, @Nullable String path, @Nullable String queryString, @Nullable String body) {
        Request request = transaction.getContext().getRequest();
        request.withMethod(httpMethod);
        this.fillUrlRelatedFields(request, serverName, path, queryString);
        if (null != headers) {
            String contentType = headers.get(CONTENT_TYPE_HEADER);
            this.setRequestHeaders(transaction, headers);
            CharBuffer bodyBuffer = this.startCaptureBody(transaction, httpMethod, contentType);
            if (bodyBuffer != null) {
                bodyBuffer.append(body);
            }
        }
    }

    protected void fillHttpResponseData(Transaction transaction, @Nullable Map<String, String> headers, int statusCode) {
        Response response = transaction.getContext().getResponse();
        response.withFinished(true);
        if (transaction.isSampled() && null != headers && this.isCaptureHeaders()) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                response.addHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        response.withStatusCode(statusCode);
        transaction.withResultIfUnset(ResultUtil.getResultByHttpStatus(statusCode));
    }

    private void fillUrlRelatedFields(Request request, @Nullable String serverName, @Nullable String path, @Nullable String queryString) {
        request.getUrl().resetState();
        request.getUrl().withProtocol("https").withHostname(serverName).withPort(443).withPathname(path).withSearch(queryString);
    }

    @Nullable
    private CharBuffer startCaptureBody(Transaction transaction, @Nullable String method, @Nullable String contentTypeHeader) {
        Request request = transaction.getContext().getRequest();
        if (this.hasBody(contentTypeHeader, method)) {
            if (this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF && contentTypeHeader != null && !contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED) && WildcardMatcher.isAnyMatch(this.webConfiguration.getCaptureContentTypes(), contentTypeHeader)) {
                return request.withBodyBuffer();
            }
            request.redactBody();
            if (this.coreConfiguration.getCaptureBody() == CoreConfiguration.EventType.OFF) {
                logger.debug("Not capturing Request body because the capture_body config option is OFF");
            }
            if (contentTypeHeader == null) {
                logger.debug("Not capturing request body because couldn't find Content-Type header");
            } else if (!contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED)) {
                logger.debug("Not capturing body for content type \"{}\". Consider updating the capture_body_content_types configuration option.", (Object)contentTypeHeader);
            }
        }
        return null;
    }

    private boolean isCaptureHeaders() {
        return this.coreConfiguration.isCaptureHeaders();
    }

    private boolean hasBody(@Nullable String contentTypeHeader, @Nullable String method) {
        return method != null && METHODS_WITH_BODY.contains(method) && contentTypeHeader != null;
    }

    @Override
    protected void setTransactionTriggerData(Transaction transaction, I apiGatewayRequest) {
        transaction.withType(TRANSACTION_TYPE);
        CloudOrigin cloudOrigin = transaction.getContext().getCloudOrigin();
        cloudOrigin.withServiceName("api gateway");
        cloudOrigin.withProvider("aws");
        transaction.getFaas().getTrigger().withType("http");
        transaction.getContext().getServiceOrigin().withVersion(this.getApiGatewayVersion());
    }

    protected void setApiGatewayContextData(Transaction transaction, @Nullable String requestId, @Nullable String apiId, @Nullable String httpMethod, @Nullable String resourcePath, @Nullable String accountId) {
        transaction.getFaas().getTrigger().withRequestId(requestId);
        ServiceOrigin serviceOrigin = transaction.getContext().getServiceOrigin();
        serviceOrigin.withName(httpMethod);
        if (httpMethod != null) {
            serviceOrigin.appendToName(" ");
        }
        serviceOrigin.appendToName(resourcePath);
        serviceOrigin.withId(apiId);
        transaction.getContext().getCloudOrigin().withAccountId(accountId);
    }

    private void setRequestHeaders(Transaction transaction, Map<String, String> headers) {
        Request req = transaction.getContext().getRequest();
        if (transaction.isSampled() && this.isCaptureHeaders()) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                req.addHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
    }

    @Override
    protected void setTransactionName(Transaction transaction, I event, Context lambdaContext) {
        StringBuilder transactionName = transaction.getAndOverrideName(100);
        String httpMethod = this.getHttpMethod(event);
        if (null != transactionName && null != httpMethod) {
            transactionName.append(httpMethod).append(" ").append(lambdaContext.getFunctionName());
        } else {
            super.setTransactionName(transaction, event, lambdaContext);
        }
    }

    protected String getHttpVersion(String protocol) {
        switch (protocol) {
            case "HTTP/1.0": {
                return "1.0";
            }
            case "HTTP/1.1": {
                return "1.1";
            }
            case "HTTP/2.0": {
                return "2.0";
            }
        }
        return protocol.replace("HTTP/", "");
    }
}

