/*
 * Decompiled with CFR 0.152.
 */
package org.stagemonitor.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stagemonitor.configuration.source.PropertyFileConfigurationSource;

public class IOUtils {
    private static final int EOF = -1;
    private static final int BUFFER_SIZE = 4096;
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public static void write(String str, OutputStream out) throws IOException {
        out.write(str.getBytes());
    }

    public static String toString(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(input);
        StringBuilder stringBuilder = new StringBuilder();
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = inputStreamReader.read(buffer))) {
            stringBuilder.append(buffer, 0, n);
        }
        return stringBuilder.toString();
    }

    public static void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void consumeAndClose(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            while (is.read() != -1) {
            }
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static InputStream getResourceAsStream(String name) {
        return IOUtils.class.getClassLoader().getResourceAsStream(name);
    }

    public static String getResourceAsString(String name) {
        try {
            return IOUtils.toString(IOUtils.getResourceAsStream(name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readToBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, output);
        return output.toByteArray();
    }

    public static File getFile(String classPathLocation) throws IOException, URISyntaxException {
        URL resource = PropertyFileConfigurationSource.class.getClassLoader().getResource(classPathLocation);
        if (resource == null) {
            resource = new URL("file://" + classPathLocation);
        }
        if (!"file".equals(resource.getProtocol())) {
            throw new IOException("Saving to property files inside a war, ear or jar is not possible.");
        }
        return new File(resource.toURI());
    }
}

