/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web.http1;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.vertx.v3.web.ResponseEndHandlerWrapper;
import co.elastic.apm.agent.vertx.v3.web.WebInstrumentation;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class HttpServerResponseImplInstrumentation
extends WebInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.vertx.core.http.impl.HttpServerResponseImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isConstructor();
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.vertx.v3.web.http1.HttpServerResponseImplInstrumentation$HttpResponseConstructorAdvice";
    }

    public static class HttpResponseConstructorAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void enter(@Advice.This HttpServerResponse response) {
            Transaction transaction = GlobalTracer.get().currentTransaction();
            if (transaction != null) {
                response.endHandler((Handler)new ResponseEndHandlerWrapper(transaction, response));
            }
        }
    }
}

