/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.vertx.v3.Vertx3Instrumentation;
import co.elastic.apm.agent.vertx.v3.web.ResponseEndHandlerWrapper;
import co.elastic.apm.agent.vertx.v3.web.WebHelper;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class WebInstrumentation
extends Vertx3Instrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("vertx", "vertx-web", "experimental");
    }

    public static class RequestBufferInstrumentation
    extends WebInstrumentation {
        @Override
        public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
            return ElementMatchers.nameStartsWith("io.vertx.core.http.impl");
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("io.vertx.core.http.HttpServerRequest")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.namedOneOf("handleData", "onData").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.core.buffer.Buffer")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.web.WebInstrumentation$RequestBufferInstrumentation$HandleDataAdvice";
        }

        public static class HandleDataAdvice {
            private static final WebHelper helper = WebHelper.getInstance();

            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void wrapHandler(@Advice.This HttpServerRequest request, @Advice.Argument(value=0) Buffer requestDataBuffer) {
                Transaction transaction = WebHelper.getInstance().getTransactionForRequest(request);
                helper.captureBody(transaction, requestDataBuffer);
            }
        }
    }

    public static class ResponseEndHandlerInstrumentation
    extends WebInstrumentation {
        @Override
        public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
            return ElementMatchers.nameStartsWith("io.vertx.core.http.impl");
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("io.vertx.core.http.HttpServerResponse"))).and(ElementMatchers.declaresField(ElementMatchers.named("endHandler")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("endHandler").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.core.Handler")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.web.WebInstrumentation$ResponseEndHandlerInstrumentation$ResponseEndHandlerAdvice";
        }

        public static class ResponseEndHandlerAdvice {
            @Nullable
            @Advice.AssignReturned.ToFields(value={@Advice.AssignReturned.ToFields.ToField(value="endHandler")})
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Handler<Void> wrapHandler(@Advice.Argument(value=0) Handler<Void> handler, @Advice.FieldValue(value="endHandler") @Nullable Handler<Void> internalHandler) {
                if (internalHandler instanceof ResponseEndHandlerWrapper && handler instanceof ResponseEndHandlerWrapper) {
                    return internalHandler;
                }
                if (handler instanceof ResponseEndHandlerWrapper) {
                    if (internalHandler != null) {
                        ((ResponseEndHandlerWrapper)handler).setActualHandler(internalHandler);
                    }
                    return handler;
                }
                if (internalHandler instanceof ResponseEndHandlerWrapper) {
                    ((ResponseEndHandlerWrapper)internalHandler).setActualHandler(handler);
                    return internalHandler;
                }
                return internalHandler;
            }
        }
    }

    public static class RouteInstrumentation
    extends WebInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("io.vertx.ext.web.impl.RouteImpl").or(ElementMatchers.named("io.vertx.ext.web.impl.RouteState"));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("handleContext").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.ext.web.impl.RoutingContextImplBase")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.web.WebInstrumentation$RouteInstrumentation$RouteImplAdvice";
        }

        public static class RouteImplAdvice {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object nextEnter(@Advice.Argument(value=0) RoutingContext routingContext) {
                Transaction transaction = WebHelper.getInstance().setRouteBasedNameForCurrentTransaction(routingContext);
                if (transaction != null) {
                    transaction.activate();
                }
                return transaction;
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            public static void nextExit(@Advice.Argument(value=0) RoutingContext routingContext, @Nullable @Advice.Enter Object transactionObj, @Nullable @Advice.Thrown Throwable thrown) {
                if (transactionObj instanceof Transaction) {
                    Transaction transaction = (Transaction)transactionObj;
                    ((Transaction)transaction.captureException(thrown)).deactivate();
                }
            }
        }
    }
}

