/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.common.ThreadUtils;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorUtils.class);

    private ExecutorUtils() {
    }

    public static ScheduledThreadPoolExecutor createSingleThreadSchedulingDaemonPool(String threadPurpose) {
        final SingleNamedThreadFactory daemonThreadFactory = new SingleNamedThreadFactory(ThreadUtils.addElasticApmThreadPrefix(threadPurpose));
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)daemonThreadFactory){

            @Override
            public String toString() {
                return super.toString() + "(thread name = " + daemonThreadFactory.threadName + ")";
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                ExecutorUtils.logException(r, t);
            }
        };
        executor.setMaximumPoolSize(1);
        return executor;
    }

    public static ThreadPoolExecutor createSingleThreadDaemonPool(String threadPurpose, int queueCapacity) {
        String threadName = ThreadUtils.addElasticApmThreadPrefix(threadPurpose);
        SingleNamedThreadFactory daemonThreadFactory = new SingleNamedThreadFactory(threadName);
        return new SingleNamedDaemonThreadPoolExecutor(queueCapacity, daemonThreadFactory, threadName);
    }

    public static ThreadPoolExecutor createThreadDaemonPool(String threadPurpose, int poolSize, int queueCapacity) {
        NamedThreadFactory daemonThreadFactory = new NamedThreadFactory(threadPurpose);
        return new NamedDaemonThreadPoolExecutor(poolSize, queueCapacity, daemonThreadFactory, threadPurpose);
    }

    static void logThreadCreation(ClassLoader originalContextCL, String threadName) {
        if (logger.isDebugEnabled()) {
            logger.debug("A new thread named `{}` was created. The original context class loader of this thread ({}) has been overridden", (Object)threadName, (Object)originalContextCL);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Stack trace related to thread creation: ", new Throwable());
        }
    }

    private static void logException(Runnable r, @Nullable Throwable t) {
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            logger.error(t.getMessage(), t);
        }
    }

    public static void shutdownAndWaitTermination(ExecutorService executor) {
        ExecutorUtils.shutdownAndWaitTermination(executor, 1L, TimeUnit.SECONDS);
    }

    public static void shutdownAndWaitTermination(ExecutorService executor, long timeout, TimeUnit unit) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(timeout, unit)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(timeout, unit)) {
                    logger.warn("Thread pool did not terminate in time " + executor);
                }
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class NamedDaemonThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final String threadPrefix;

        NamedDaemonThreadPoolExecutor(int poolSize, int queueCapacity, ThreadFactory daemonThreadFactory, String threadPrefix) {
            super(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), daemonThreadFactory);
            this.threadPrefix = threadPrefix;
        }

        @Override
        public String toString() {
            return super.toString() + "(threads name prefix = " + this.threadPrefix + ")";
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            ExecutorUtils.logException(r, t);
        }
    }

    private static class SingleNamedDaemonThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final String threadName;

        SingleNamedDaemonThreadPoolExecutor(int queueCapacity, ThreadFactory daemonThreadFactory, String threadName) {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), daemonThreadFactory);
            this.threadName = threadName;
        }

        @Override
        public String toString() {
            return super.toString() + "(thread name = " + this.threadName + ")";
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            ExecutorUtils.logException(r, t);
        }
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private final String threadPurpose;
        private final AtomicInteger threadCounter;

        public NamedThreadFactory(String threadPurpose) {
            this.threadPurpose = threadPurpose;
            this.threadCounter = new AtomicInteger();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            String threadName = ThreadUtils.addElasticApmThreadPrefix(this.threadPurpose) + "-" + this.threadCounter.getAndIncrement();
            thread.setName(threadName);
            ClassLoader originalContextCL = thread.getContextClassLoader();
            thread.setContextClassLoader(null);
            ExecutorUtils.logThreadCreation(originalContextCL, threadName);
            return thread;
        }
    }

    public static class SingleNamedThreadFactory
    implements ThreadFactory {
        private final String threadName;

        public SingleNamedThreadFactory(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName(this.threadName);
            ClassLoader originalContextCL = thread.getContextClassLoader();
            thread.setContextClassLoader(null);
            ExecutorUtils.logThreadCreation(originalContextCL, this.threadName);
            return thread;
        }
    }
}

