/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.urlconnection;

import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import java.net.HttpURLConnection;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConnectionPropertyAccessor
implements TextHeaderSetter<HttpURLConnection>,
TextHeaderGetter<HttpURLConnection> {
    private static final UrlConnectionPropertyAccessor INSTANCE = new UrlConnectionPropertyAccessor();
    private static final Logger logger = LoggerFactory.getLogger(UrlConnectionPropertyAccessor.class);

    public static UrlConnectionPropertyAccessor instance() {
        return INSTANCE;
    }

    @Override
    public void setHeader(String headerName, String headerValue, HttpURLConnection urlConnection) {
        block3: {
            try {
                urlConnection.addRequestProperty(headerName, headerValue);
            }
            catch (IllegalStateException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Failed to add header to the request", e);
                }
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Failed to add header {} to the request through HttpUrlConnection: {}", (Object)headerName, (Object)e.getMessage());
            }
        }
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, HttpURLConnection urlConnection) {
        return urlConnection.getRequestProperty(headerName);
    }

    @Override
    public <S> void forEach(String headerName, HttpURLConnection carrier, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        List<String> values = carrier.getRequestProperties().get(headerName);
        if (values != null) {
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                consumer.accept(values.get(i), state);
            }
        }
    }
}

