/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebmvc;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletContext;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;

public class SpringServiceNameInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameEndsWith("ApplicationContext");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.context.WebApplicationContext"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("initPropertySources").and(ElementMatchers.takesArguments(0));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("spring-service-name");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.springwebmvc.SpringServiceNameInstrumentation$SpringServiceNameAdvice";
    }

    public static class SpringServiceNameAdvice {
        private static final Logger logger = LoggerFactory.getLogger(SpringServiceNameAdvice.class);

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void afterInitPropertySources(@Advice.This WebApplicationContext applicationContext) {
            String appName;
            ClassLoader classLoader = applicationContext.getClassLoader();
            ServletContext servletContext = applicationContext.getServletContext();
            if (servletContext != null) {
                try {
                    ClassLoader servletClassloader = servletContext.getClassLoader();
                    if (servletClassloader != null) {
                        classLoader = servletClassloader;
                    }
                }
                catch (UnsupportedOperationException servletClassloader) {
                    // empty catch block
                }
            }
            if (!(appName = applicationContext.getEnvironment().getProperty("spring.application.name", "")).isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting service name `{}` to be used for class loader [{}], based on the value of the `spring.application.name` environment variable", (Object)appName, (Object)classLoader);
                }
            } else {
                appName = applicationContext.getApplicationName();
                if (appName.startsWith("/")) {
                    appName = appName.substring(1);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("``spring.application.name` environment variable is not set, falling back to using `{}` as service name for class loader [{}]", (Object)appName, (Object)classLoader);
                }
            }
            TracerAwareInstrumentation.tracer.overrideServiceNameForClassLoader(classLoader, appName);
        }
    }
}

