/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebmvc;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ExceptionHandlerInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.springwebmvc.ExceptionHandlerInstrumentation$ExceptionHandlerAdviceService";
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.springframework.web.servlet.DispatcherServlet");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("processHandlerException").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletResponse"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("java.lang.Object"))).and(ElementMatchers.takesArgument(3, ElementMatchers.named("java.lang.Exception"))).and(ElementMatchers.returns(ElementMatchers.named("org.springframework.web.servlet.ModelAndView")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("exception-handler");
    }

    public static class ExceptionHandlerAdviceService {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void captureException(@Advice.Argument(value=0) @Nullable HttpServletRequest request, @Advice.Argument(value=3) @Nullable Exception e) {
            if (request != null && e != null) {
                request.setAttribute("co.elastic.apm.exception", (Object)e);
            }
        }
    }
}

