/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebflux;

import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.springwebflux.WebfluxHelper;
import javax.annotation.Nullable;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;

class TransactionAwareSubscriber<T>
implements CoreSubscriber<T>,
Subscription {
    private static final Logger log = LoggerFactory.getLogger(TransactionAwareSubscriber.class);
    private static final WeakMap<TransactionAwareSubscriber<?>, Transaction> transactionMap = WeakConcurrentProviderImpl.createWeakSpanMap();
    private final CoreSubscriber<? super T> subscriber;
    private final ServerWebExchange exchange;
    private final String description;
    private final Context context;
    private Subscription subscription;

    TransactionAwareSubscriber(CoreSubscriber<? super T> subscriber, Transaction transaction, ServerWebExchange exchange, String description) {
        this.subscriber = subscriber;
        this.exchange = exchange;
        this.description = description;
        transactionMap.put(this, transaction);
        this.context = subscriber.currentContext().put(AbstractSpan.class, (Object)transaction);
    }

    public Context currentContext() {
        return this.context;
    }

    public void request(long n) {
        this.subscription.request(n);
    }

    public void cancel() {
        this.subscription.cancel();
        this.cancelTransaction();
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        Transaction transaction = this.getTransaction();
        this.doEnter("onSubscribe", transaction);
        Throwable thrown = null;
        try {
            this.subscriber.onSubscribe((Subscription)this);
            this.doExit(thrown != null, "onSubscribe", transaction);
        }
        catch (Throwable e) {
            try {
                thrown = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.doExit(thrown != null, "onSubscribe", transaction);
                throw throwable;
            }
        }
    }

    public void onNext(T next) {
        Transaction transaction = this.getTransaction();
        this.doEnter("onNext", transaction);
        Throwable thrown = null;
        try {
            this.subscriber.onNext(next);
            this.doExit(thrown != null, "onNext", transaction);
        }
        catch (Throwable e) {
            try {
                thrown = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.doExit(thrown != null, "onNext", transaction);
                throw throwable;
            }
        }
    }

    public void onError(Throwable t) {
        Transaction transaction = this.getTransaction();
        this.doEnter("onError", transaction);
        try {
            this.subscriber.onError(t);
        }
        finally {
            WebfluxHelper.endTransaction(t, transaction, this.exchange);
            this.doExit(true, "onError", transaction);
        }
    }

    public void onComplete() {
        Transaction transaction = this.getTransaction();
        this.doEnter("onComplete", transaction);
        try {
            this.subscriber.onComplete();
        }
        finally {
            WebfluxHelper.endTransaction(null, transaction, this.exchange);
            this.doExit(true, "onComplete", transaction);
        }
    }

    private void doEnter(String method, @Nullable Transaction transaction) {
        this.debugTrace(true, method, transaction);
        if (transaction == null) {
            return;
        }
        transaction.activate();
    }

    private void doExit(boolean discard, String method, @Nullable Transaction transaction) {
        this.debugTrace(false, method, transaction);
        if (transaction == null) {
            return;
        }
        transaction.deactivate();
        if (discard) {
            transactionMap.remove(this);
        }
    }

    private void cancelTransaction() {
        Transaction transaction = this.getTransaction();
        this.debugTrace(true, "cancelTransaction", transaction);
        try {
            if (transaction == null) {
                return;
            }
            WebfluxHelper.endTransaction(null, transaction, this.exchange);
            transactionMap.remove(this);
        }
        finally {
            this.debugTrace(false, "cancelTransaction", transaction);
        }
    }

    @Nullable
    private Transaction getTransaction() {
        return transactionMap.get(this);
    }

    private void debugTrace(boolean isEnter, String method, @Nullable Transaction transaction) {
        if (!log.isTraceEnabled()) {
            return;
        }
        log.trace("{} {} {} {}", isEnter ? ">>>>" : "<<<<", this.description, method, transaction);
    }
}

