/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebflux;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.springwebflux.WebFluxInstrumentation;
import co.elastic.apm.agent.springwebflux.WebfluxHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DispatcherHandlerInstrumentation
extends WebFluxInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.springframework.web.reactive.DispatcherHandler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handle").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.springframework.web.server.ServerWebExchange")));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.springwebflux.DispatcherHandlerInstrumentation$HandleAdvice";
    }

    public static class HandleAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.Argument(value=0) ServerWebExchange exchange) {
            List upgradeHeader = exchange.getRequest().getHeaders().get((Object)"upgrade");
            if (upgradeHeader != null && upgradeHeader.contains("websocket")) {
                return null;
            }
            return WebfluxHelper.getOrCreateTransaction(TracerAwareInstrumentation.tracer, exchange);
        }

        @Nullable
        @Advice.AssignReturned.ToReturned(typing=Assigner.Typing.DYNAMIC)
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static Object onExit(@Advice.Enter @Nullable Object enterTransaction, @Advice.Argument(value=0) ServerWebExchange exchange, @Advice.Thrown @Nullable Throwable thrown, @Advice.Return @Nullable Mono<?> returnValue) {
            if (!(enterTransaction instanceof Transaction)) {
                return returnValue;
            }
            Transaction transaction = (Transaction)enterTransaction;
            transaction.deactivate();
            if (thrown != null || returnValue == null) {
                return returnValue;
            }
            return WebfluxHelper.wrapDispatcher(returnValue, transaction, exchange);
        }
    }
}

