/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.servlet.ServletApiAdvice;
import co.elastic.apm.agent.servlet.ServletGlobalState;
import co.elastic.apm.agent.util.TransactionNameUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletTransactionHelper {
    public static final String TRANSACTION_ATTRIBUTE = ServletApiAdvice.class.getName() + ".transaction";
    public static final String ASYNC_ATTRIBUTE = ServletApiAdvice.class.getName() + ".async";
    private static final String CONTENT_TYPE_FROM_URLENCODED = "application/x-www-form-urlencoded";
    private static final WildcardMatcher ENDS_WITH_JSP = WildcardMatcher.valueOf("*.jsp");
    private static final Logger logger = LoggerFactory.getLogger(ServletTransactionHelper.class);
    private final Set<String> METHODS_WITH_BODY = new HashSet<String>(Arrays.asList("POST", "PUT", "PATCH", "DELETE"));
    private final CoreConfiguration coreConfiguration;
    private final WebConfiguration webConfiguration;

    public ServletTransactionHelper(ElasticApmTracer tracer) {
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        this.webConfiguration = tracer.getConfig(WebConfiguration.class);
    }

    public static void determineServiceName(@Nullable String servletContextName, @Nullable ClassLoader servletContextClassLoader, @Nullable String contextPath) {
        String serviceName;
        if (servletContextClassLoader == null || ServletGlobalState.nameInitialized.putIfAbsent(servletContextClassLoader, Boolean.TRUE) != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Inferring service name for class loader [{}] based on servlet context path `{}` and request context path `{}`", servletContextClassLoader, servletContextName, contextPath);
        }
        if ("application".equals(serviceName = servletContextName) || "".equals(serviceName) || "/".equals(serviceName)) {
            serviceName = null;
        }
        if (serviceName == null && contextPath != null && !contextPath.isEmpty()) {
            serviceName = contextPath.substring(1);
        }
        if (serviceName != null) {
            GlobalTracer.get().overrideServiceNameForClassLoader(servletContextClassLoader, serviceName);
        }
    }

    public void fillRequestContext(Transaction transaction, String protocol, String method, boolean secure, String scheme, String serverName, int serverPort, String requestURI, String queryString, String remoteAddr, @Nullable String contentTypeHeader) {
        this.startCaptureBody(transaction, method, contentTypeHeader);
        Request request = transaction.getContext().getRequest();
        request.withHttpVersion(protocol).withMethod(method);
        request.getSocket().withRemoteAddress(remoteAddr);
        request.getUrl().withProtocol(scheme).withHostname(serverName).withPort(serverPort).withPathname(requestURI).withSearch(queryString);
    }

    private void startCaptureBody(Transaction transaction, String method, @Nullable String contentTypeHeader) {
        Request request = transaction.getContext().getRequest();
        if (this.hasBody(contentTypeHeader, method)) {
            if (this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF && contentTypeHeader != null && !contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED) && WildcardMatcher.isAnyMatch(this.webConfiguration.getCaptureContentTypes(), contentTypeHeader)) {
                request.withBodyBuffer();
            } else {
                request.redactBody();
                if (this.coreConfiguration.getCaptureBody() == CoreConfiguration.EventType.OFF) {
                    logger.debug("Not capturing Request body because the capture_body config option is OFF");
                }
                if (contentTypeHeader == null) {
                    logger.debug("Not capturing request body because couldn't find Content-Type header");
                } else if (!contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED)) {
                    logger.debug("Not capturing body for content type \"{}\". Consider updating the capture_body_content_types configuration option.", (Object)contentTypeHeader);
                }
            }
        }
    }

    public static void setUsernameIfUnset(@Nullable String userName, TransactionContext context) {
        if (context.getUser().getUsername() == null) {
            context.getUser().withUsername(userName);
        }
    }

    public void onAfter(Transaction transaction, @Nullable Throwable exception, boolean committed, int status, boolean overrideStatusCodeOnThrowable, String method, @Nullable Map<String, String[]> parameterMap, @Nullable String servletPath, @Nullable String pathInfo, @Nullable String contentTypeHeader, boolean deactivate) {
        if (servletPath == null) {
            servletPath = "";
        }
        try {
            if (exception != null && "weblogic.servlet.jsp.AddToMapException".equals(exception.getClass().getName())) {
                transaction.ignoreTransaction();
            } else {
                this.doOnAfter(transaction, exception, committed, status, overrideStatusCodeOnThrowable, method, parameterMap, servletPath, pathInfo, contentTypeHeader);
            }
        }
        catch (RuntimeException e) {
            logger.warn("Exception while capturing Elastic APM transaction", e);
        }
        if (deactivate) {
            transaction.deactivate();
        }
        transaction.end();
    }

    private void doOnAfter(Transaction transaction, @Nullable Throwable exception, boolean committed, int status, boolean overrideStatusCodeOnThrowable, String method, @Nullable Map<String, String[]> parameterMap, String servletPath, @Nullable String pathInfo, @Nullable String contentTypeHeader) {
        this.fillRequestParameters(transaction, method, parameterMap, contentTypeHeader);
        if (exception != null && status == 200 && overrideStatusCodeOnThrowable) {
            status = 500;
        }
        this.fillResponse(transaction.getContext().getResponse(), committed, status);
        transaction.withResultIfUnset(ResultUtil.getResultByHttpStatus(status)).withType("request").captureException(exception);
        this.applyDefaultTransactionName(method, servletPath, pathInfo, transaction);
    }

    void applyDefaultTransactionName(String method, String servletPath, @Nullable String pathInfo, Transaction transaction) {
        if (this.webConfiguration.isUsePathAsName() || ENDS_WITH_JSP.matches(servletPath, pathInfo)) {
            TransactionNameUtils.setNameFromHttpRequestPath(method, servletPath, pathInfo, transaction.getAndOverrideName(11), this.webConfiguration.getUrlGroups());
        } else {
            StringBuilder transactionName = transaction.getAndOverrideName(0);
            if (transactionName != null) {
                transactionName.append(method).append(" unknown route");
            }
        }
    }

    private void fillRequestParameters(Transaction transaction, String method, @Nullable Map<String, String[]> parameterMap, @Nullable String contentTypeHeader) {
        Request request = transaction.getContext().getRequest();
        if (this.hasBody(contentTypeHeader, method) && this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF && parameterMap != null) {
            this.captureParameters(request, parameterMap, contentTypeHeader);
        }
    }

    public boolean captureParameters(String method, @Nullable String contentTypeHeader) {
        return contentTypeHeader != null && contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED) && this.hasBody(contentTypeHeader, method) && this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF && WildcardMatcher.isAnyMatch(this.webConfiguration.getCaptureContentTypes(), contentTypeHeader);
    }

    private void fillResponse(Response response, boolean committed, int status) {
        response.withFinished(true);
        response.withHeadersSent(committed);
        response.withStatusCode(status);
    }

    private boolean hasBody(@Nullable String contentTypeHeader, String method) {
        return this.METHODS_WITH_BODY.contains(method) && contentTypeHeader != null;
    }

    private void captureParameters(Request request, Map<String, String[]> params, @Nullable String contentTypeHeader) {
        if (contentTypeHeader != null && contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED)) {
            for (Map.Entry<String, String[]> param : params.entrySet()) {
                request.addFormUrlEncodedParameters(param.getKey(), param.getValue());
            }
        }
    }

    public boolean isCaptureHeaders() {
        return this.coreConfiguration.isCaptureHeaders();
    }
}

