/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.servlet.AsyncInstrumentation;
import co.elastic.apm.agent.servlet.helper.AsyncContextAdviceHelper;
import co.elastic.apm.agent.servlet.helper.JavaxAsyncContextAdviceHelper;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import net.bytebuddy.asm.Advice;

public class JavaxAsyncInstrumentation {

    public static class JavaxAsyncContextInstrumentation
    extends AsyncInstrumentation.AsyncContextInstrumentation {
        @Override
        String asyncContextClassName() {
            return "javax.servlet.AsyncContext";
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.servlet.AsyncInstrumentation$AsyncContextInstrumentation$AsyncContextStartAdvice";
        }

        @Override
        public String rootClassNameThatClassloaderCanLoad() {
            return "javax.servlet.AsyncContext";
        }
    }

    public static class JavaxStartAsyncInstrumentation
    extends AsyncInstrumentation.StartAsyncInstrumentation {
        @Override
        String servletRequestClassName() {
            return "javax.servlet.ServletRequest";
        }

        @Override
        String asyncContextClassName() {
            return "javax.servlet.AsyncContext";
        }

        @Override
        String servletResponseClassName() {
            return "javax.servlet.ServletResponse";
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.servlet.JavaxAsyncInstrumentation$JavaxStartAsyncInstrumentation$StartAsyncAdvice";
        }

        @Override
        public String rootClassNameThatClassloaderCanLoad() {
            return "javax.servlet.AsyncContext";
        }

        public static class StartAsyncAdvice {
            private static final AsyncContextAdviceHelper<AsyncContext> asyncHelper = new JavaxAsyncContextAdviceHelper(GlobalTracer.requireTracerImpl());

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void onExitStartAsync(@Advice.Return @Nullable AsyncContext asyncContext) {
                if (asyncContext == null) {
                    return;
                }
                asyncHelper.onExitStartAsync(asyncContext);
            }
        }
    }
}

