/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.servlet.JakartaUtil;
import co.elastic.apm.agent.servlet.ServletVersionInstrumentation;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;

public abstract class JakartaServletVersionInstrumentation
extends ServletVersionInstrumentation {
    private static String getServletVersionTypeMatcherClassName() {
        return "jakarta.servlet.Servlet";
    }

    private static String getRootClassNameThatClassloaderCanLoad() {
        return "jakarta.servlet.AsyncContext";
    }

    public static class JakartaService
    extends ServletVersionInstrumentation.Service {
        @Override
        public String rootClassNameThatClassloaderCanLoad() {
            return JakartaServletVersionInstrumentation.getRootClassNameThatClassloaderCanLoad();
        }

        @Override
        String[] getServiceMethodArgumentClassNames() {
            return new String[]{"jakarta.servlet.ServletRequest", "jakarta.servlet.ServletResponse"};
        }

        @Override
        public String servletVersionTypeMatcherClassName() {
            return JakartaServletVersionInstrumentation.getServletVersionTypeMatcherClassName();
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.This Servlet servlet) {
                ServletVersionInstrumentation.logServletVersion(JakartaUtil.getInfoFromServletContext(servlet.getServletConfig()));
            }
        }
    }

    public static class JakartaInit
    extends ServletVersionInstrumentation.Init {
        @Override
        public String servletVersionTypeMatcherClassName() {
            return JakartaServletVersionInstrumentation.getServletVersionTypeMatcherClassName();
        }

        @Override
        public String rootClassNameThatClassloaderCanLoad() {
            return JakartaServletVersionInstrumentation.getRootClassNameThatClassloaderCanLoad();
        }

        @Override
        String initMethodArgumentClassName() {
            return "jakarta.servlet.ServletConfig";
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.Argument(value=0) @Nullable ServletConfig servletConfig) {
                ServletVersionInstrumentation.logServletVersion(JakartaUtil.getInfoFromServletContext(servletConfig));
            }
        }
    }
}

