/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.concurrent.JavaConcurrent;
import co.elastic.apm.agent.servlet.AbstractServletInstrumentation;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class AsyncInstrumentation
extends AbstractServletInstrumentation {
    private static final String SERVLET_API_ASYNC_GROUP_NAME = "servlet-api-async";

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("servlet-api", SERVLET_API_ASYNC_GROUP_NAME);
    }

    public static abstract class AsyncContextInstrumentation
    extends AsyncInstrumentation {
        @Override
        public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
            return ElementMatchers.nameContains("AsyncContext");
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named(this.asyncContextClassName())));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.isPublic().and(ElementMatchers.named("start")).and(ElementMatchers.takesArguments(Runnable.class));
        }

        abstract String asyncContextClassName();

        public static class AsyncContextStartAdvice {
            @Nullable
            @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Runnable onEnterAsyncContextStart(@Advice.Argument(value=0) @Nullable Runnable runnable) {
                return JavaConcurrent.withContext(runnable, TracerAwareInstrumentation.tracer);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Exception.class, inline=false)
            public static void onExitAsyncContextStart(@Nullable @Advice.Thrown Throwable thrown, @Advice.Argument(value=0) @Nullable Runnable runnable) {
                JavaConcurrent.doFinally(thrown, runnable);
            }
        }
    }

    public static abstract class StartAsyncInstrumentation
    extends AsyncInstrumentation {
        @Override
        public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
            return ElementMatchers.nameContains("Request");
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named(this.servletRequestClassName())));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.isPublic().and(ElementMatchers.named("startAsync")).and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named(this.asyncContextClassName())))).and(ElementMatchers.takesArguments(0).or(ElementMatchers.takesArgument(0, ElementMatchers.named(this.servletRequestClassName())).and(ElementMatchers.takesArgument(1, ElementMatchers.named(this.servletResponseClassName())))));
        }

        abstract String servletRequestClassName();

        abstract String asyncContextClassName();

        abstract String servletResponseClassName();
    }
}

