/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report.ssl;

import co.elastic.apm.agent.report.ssl.TLSFallbackSSLSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TLSFallbackSSLSocket
extends SSLSocket {
    private static final Logger logger = LoggerFactory.getLogger(TLSFallbackSSLSocket.class);
    static final String TLS_v_1_3 = "TLSv1.3";
    private final TLSFallbackSSLSocketFactory socketFactory;
    private SSLSocket socket;

    TLSFallbackSSLSocket(SSLSocket socket, TLSFallbackSSLSocketFactory socketFactory) {
        this.socket = socket;
        this.socketFactory = socketFactory;
    }

    @Override
    public void startHandshake() throws IOException {
        HashSet<String> enabledProtocols = new HashSet<String>(Arrays.asList(this.socket.getEnabledProtocols()));
        boolean hasTLS13 = enabledProtocols.contains(TLS_v_1_3);
        AtomicBoolean skipTLS13 = this.socketFactory.skipTLS13();
        if (hasTLS13 && skipTLS13.get()) {
            enabledProtocols.remove(TLS_v_1_3);
            this.socket.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            hasTLS13 = false;
        }
        try {
            this.socket.startHandshake();
        }
        catch (SSLHandshakeException e) {
            if (hasTLS13 && e.getMessage().contains("should not be presented in")) {
                boolean hasBeenWarned = skipTLS13.getAndSet(true);
                if (!hasBeenWarned) {
                    logger.warn("Workaround for JDK Bug JDK-8236039 applied, will connect without TLS v1.3. Update JRE/JDK to fix this, or disable TLS v1.3 on APM Server as a workaround (apm-server.ssl.supported_protocols)");
                }
                InetAddress socketAddress = this.socket.getInetAddress();
                int socketPort = this.socket.getPort();
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
                this.socket = (SSLSocket)this.socketFactory.getOriginalFactory().createSocket(socketAddress, socketPort);
                enabledProtocols.remove(TLS_v_1_3);
                this.socket.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
                this.socket.startHandshake();
            }
            this.logSslInfo();
            throw e;
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socket.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.socket.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.socket.setEnabledCipherSuites(suites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.socket.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.socket.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.socket.setEnabledProtocols(protocols);
    }

    @Override
    public SSLSession getSession() {
        return this.socket.getSession();
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.socket.getHandshakeSession();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.socket.addHandshakeCompletedListener(listener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.socket.removeHandshakeCompletedListener(listener);
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.socket.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.socket.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.socket.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.socket.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.socket.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.socket.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.socket.setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.socket.getEnableSessionCreation();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.socket.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.socket.setSSLParameters(params);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        try {
            this.socket.connect(endpoint);
        }
        catch (IOException e) {
            this.logSslInfo();
            throw e;
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        try {
            this.socket.connect(endpoint, timeout);
        }
        catch (IOException e) {
            this.logSslInfo();
            throw e;
        }
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        try {
            this.socket.bind(bindpoint);
        }
        catch (IOException e) {
            this.logSslInfo();
            throw e;
        }
    }

    private void logSslInfo() {
        SSLSession session = this.socket.getSession();
        if (session != null) {
            try {
                logger.info("APM Server certificates: {}", (Object)Arrays.toString(session.getPeerCertificates()));
            }
            catch (SSLPeerUnverifiedException e) {
                logger.info("APM Server identity could not be verified");
            }
            logger.info("Local certificates: {}", (Object)Arrays.toString(session.getLocalCertificates()));
        }
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.socket.sendUrgentData(data);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.socket.toString();
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.socket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.socket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }
}

