/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.locks.LockSupport;

public final class ExponentionallyIncreasingSleepingWaitStrategy
implements WaitStrategy {
    private final int sleepTimeNsStart;
    private final int sleepTimeNsMax;

    public ExponentionallyIncreasingSleepingWaitStrategy(int sleepTimeNsStart, int sleepTimeNsMax) {
        this.sleepTimeNsStart = sleepTimeNsStart;
        this.sleepTimeNsMax = sleepTimeNsMax;
    }

    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException {
        long availableSequence;
        int currentSleep = this.sleepTimeNsStart;
        while ((availableSequence = dependentSequence.get()) < sequence) {
            currentSleep = this.applyWaitMethod(barrier, currentSleep);
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
    }

    private int applyWaitMethod(SequenceBarrier barrier, int currentSleep) throws AlertException {
        barrier.checkAlert();
        if (currentSleep < this.sleepTimeNsMax) {
            LockSupport.parkNanos(currentSleep);
            return currentSleep * 2;
        }
        LockSupport.parkNanos(this.sleepTimeNsMax);
        return currentSleep;
    }
}

