/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.dslplatform.json.JsonWriter;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nullable;

public class ReportingEvent {
    @Nullable
    private Transaction transaction;
    @Nullable
    private ReportingEventType type;
    @Nullable
    private ErrorCapture error;
    @Nullable
    private Span span;
    @Nullable
    private JsonWriter jsonWriter;
    @Nullable
    private Thread unparkAfterProcessed;

    public void resetState() {
        this.transaction = null;
        this.type = null;
        this.error = null;
        this.span = null;
        this.jsonWriter = null;
        this.unparkAfterProcessed = null;
    }

    @Nullable
    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
        this.type = ReportingEventType.TRANSACTION;
    }

    public void setEndRequestEvent() {
        this.type = ReportingEventType.END_REQUEST;
    }

    @Nullable
    public ReportingEventType getType() {
        return this.type;
    }

    @Nullable
    public ErrorCapture getError() {
        return this.error;
    }

    @Nullable
    public Span getSpan() {
        return this.span;
    }

    public void setError(ErrorCapture error) {
        this.error = error;
        this.type = ReportingEventType.ERROR;
    }

    public void setSpan(Span span) {
        this.span = span;
        this.type = ReportingEventType.SPAN;
    }

    public void shutdownEvent() {
        this.type = ReportingEventType.SHUTDOWN;
    }

    public String toString() {
        StringBuilder description = new StringBuilder();
        description.append("Type: ").append((Object)this.type);
        if (this.transaction != null) {
            description.append(", ").append(this.transaction.toString());
        } else if (this.span != null) {
            description.append(", ").append(this.span.toString());
        }
        return description.toString();
    }

    @Nullable
    public JsonWriter getJsonWriter() {
        return this.jsonWriter;
    }

    public void setJsonWriter(@Nullable JsonWriter jsonWriter) {
        this.jsonWriter = jsonWriter;
        this.type = ReportingEventType.JSON_WRITER;
    }

    public void end() {
        if (this.transaction != null) {
            this.transaction.decrementReferences();
        } else if (this.span != null) {
            this.span.decrementReferences();
        } else if (this.error != null) {
            this.error.recycle();
        }
        if (this.unparkAfterProcessed != null) {
            LockSupport.unpark(this.unparkAfterProcessed);
        }
    }

    public void unparkAfterProcessed(@Nullable Thread thread) {
        this.unparkAfterProcessed = thread;
    }

    public void setWakeupEvent() {
        this.type = ReportingEventType.WAKEUP;
    }

    static enum ReportingEventType {
        END_REQUEST,
        TRANSACTION,
        SPAN,
        ERROR,
        SHUTDOWN,
        JSON_WRITER,
        WAKEUP;

    }
}

