/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.redis;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import javax.annotation.Nullable;

public class RedisSpanUtils {
    @Nullable
    public static Span createRedisSpan(String command) {
        AbstractSpan<?> activeSpan = GlobalTracer.get().getActive();
        if (activeSpan == null || activeSpan.isExit()) {
            return null;
        }
        Span span = ((Span)activeSpan.createSpan().withName(command)).withType("db").withSubtype("redis").withAction("query");
        span.getContext().getDestination().getService().withName("redis").withResource("redis").withType("db");
        return (Span)((Span)span.asExit()).activate();
    }
}

