/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.rabbitmq.MessageBatchHelper;
import co.elastic.apm.agent.rabbitmq.SpringBaseInstrumentation;
import java.util.List;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.amqp.core.Message;

public class SpringAmqpBatchMessageListenerInstrumentation
extends SpringBaseInstrumentation {
    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("onMessageBatch").and(ElementMatchers.takesArgument(0, List.class)).and(ElementMatchers.isPublic());
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.rabbitmq.SpringAmqpBatchMessageListenerInstrumentation$MessageListenerContainerWrappingAdvice";
    }

    public static class MessageListenerContainerWrappingAdvice
    extends SpringBaseInstrumentation.BaseAdvice {
        protected static final MessageBatchHelper messageBatchHelper;

        @Nullable
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
        @Advice.OnMethodEnter(inline=false)
        public static List<Message> beforeOnBatch(@Advice.Argument(value=0) @Nullable List<Message> messageBatch) {
            if (!TracerAwareInstrumentation.tracer.isRunning() || TracerAwareInstrumentation.tracer.currentTransaction() != null || messageBatch == null) {
                return messageBatch;
            }
            return messageBatchHelper.wrapMessageBatchList(messageBatch);
        }

        static {
            ElasticApmTracer elasticApmTracer = GlobalTracer.requireTracerImpl();
            messageBatchHelper = new MessageBatchHelper(elasticApmTracer, transactionHelper);
        }
    }
}

