/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.rabbitmq.MessageListenerHelper;
import co.elastic.apm.agent.rabbitmq.SpringBaseInstrumentation;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.amqp.core.MessageListener;

public class SetMessageListenerInstrumentation
extends SpringBaseInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Container");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("setMessageListener").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.springframework.amqp.core.MessageListener")));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.rabbitmq.SetMessageListenerInstrumentation$MessageListenerContainerWrappingAdvice";
    }

    public static class MessageListenerContainerWrappingAdvice {
        private static final MessageListenerHelper helper = new MessageListenerHelper();

        @Nullable
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
        @Advice.OnMethodEnter(inline=false)
        public static MessageListener beforeSetListener(@Advice.Argument(value=0) @Nullable MessageListener original) {
            return helper.registerAndWrapLambda(original);
        }
    }
}

