/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.rabbitmq.MessageBatchListWrapper;
import co.elastic.apm.agent.rabbitmq.SpringAmqpTransactionHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;

public class MessageBatchHelper {
    public static final Logger logger = LoggerFactory.getLogger(MessageBatchHelper.class);
    private final ElasticApmTracer tracer;
    private final SpringAmqpTransactionHelper transactionHelper;

    public MessageBatchHelper(ElasticApmTracer tracer, SpringAmqpTransactionHelper transactionHelper) {
        this.tracer = tracer;
        this.transactionHelper = transactionHelper;
    }

    public List<Message> wrapMessageBatchList(List<Message> messageBatchList) {
        try {
            return new MessageBatchListWrapper(messageBatchList, this.tracer, this.transactionHelper);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Spring AMQP MessageListener list", throwable);
            return messageBatchList;
        }
    }
}

