/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.process;

import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.sdk.state.GlobalVariables;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import java.util.List;
import javax.annotation.Nonnull;

class ProcessHelper {
    private static final ProcessHelper INSTANCE = new ProcessHelper(WeakConcurrentProviderImpl.createWeakSpanMap());
    private static final ThreadLocal<Boolean> inTracingContext = GlobalVariables.get(ProcessHelper.class, "inTracingContext", new ThreadLocal());
    private final WeakMap<Process, Span> inFlightSpans;

    ProcessHelper(WeakMap<Process, Span> inFlightSpans) {
        this.inFlightSpans = inFlightSpans;
    }

    public static boolean isTracingOnCurrentThread() {
        return inTracingContext.get() == Boolean.TRUE;
    }

    static void startProcess(AbstractSpan<?> parentContext, Process process, List<String> command) {
        INSTANCE.doStartProcess(parentContext, process, command.get(0));
    }

    static void endProcess(@Nonnull Process process, boolean checkTerminatedProcess) {
        INSTANCE.doEndProcess(process, checkTerminatedProcess);
    }

    static void endProcessSpan(@Nonnull Process process, int exitValue) {
        INSTANCE.doEndProcessSpan(process, exitValue);
    }

    void doStartProcess(@Nonnull AbstractSpan<?> parentContext, @Nonnull Process process, @Nonnull String processName) {
        if (this.inFlightSpans.containsKey(process)) {
            return;
        }
        String binaryName = ProcessHelper.getBinaryName(processName);
        Span span = (Span)parentContext.createSpan().withType("process").withName(binaryName);
        this.inFlightSpans.put(process, span);
    }

    private static String getBinaryName(String processName) {
        int lastSeparator = processName.lastIndexOf(System.getProperty("file.separator"));
        return lastSeparator < 0 ? processName : processName.substring(lastSeparator + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doEndProcess(Process process, boolean checkTerminatedProcess) {
        boolean endAndRemoveSpan;
        Span span = this.inFlightSpans.get(process);
        if (span == null) {
            return;
        }
        Outcome outcome = Outcome.UNKNOWN;
        boolean bl = endAndRemoveSpan = !checkTerminatedProcess;
        if (checkTerminatedProcess) {
            try {
                inTracingContext.set(Boolean.TRUE);
                int exitValue = process.exitValue();
                outcome = exitValue == 0 ? Outcome.SUCCESS : Outcome.FAILURE;
                endAndRemoveSpan = true;
            }
            catch (IllegalThreadStateException e) {
                outcome = Outcome.UNKNOWN;
                endAndRemoveSpan = false;
            }
            finally {
                inTracingContext.remove();
            }
        }
        if (endAndRemoveSpan) {
            this.removeAndEndSpan(process, outcome);
        }
    }

    void doEndProcessSpan(Process process, int exitValue) {
        this.removeAndEndSpan(process, exitValue == 0 ? Outcome.SUCCESS : Outcome.FAILURE);
    }

    private void removeAndEndSpan(Process process, Outcome outcome) {
        Span span = this.inFlightSpans.remove(process);
        if (span != null) {
            ((Span)span.withOutcome(outcome)).end();
        }
    }
}

