/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderInjectorBridge
implements TextHeaderSetter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(HeaderInjectorBridge.class);
    @Nullable
    private static HeaderInjectorBridge INSTANCE;
    private final MethodHandle addHeaderMethod;

    public static HeaderInjectorBridge get(MethodHandle addHeaderMethod) {
        if (INSTANCE == null) {
            INSTANCE = new HeaderInjectorBridge(addHeaderMethod);
        }
        return INSTANCE;
    }

    private HeaderInjectorBridge(MethodHandle addHeaderMethod) {
        this.addHeaderMethod = addHeaderMethod;
    }

    @Override
    public void setHeader(String headerName, String headerValue, Object carrier) {
        try {
            this.addHeaderMethod.invoke(carrier, headerName, headerValue);
        }
        catch (Throwable throwable) {
            logger.error("Failed to add trace context headers", throwable);
        }
    }
}

