/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.okhttp;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.okhttp.AbstractOkHttpClientInstrumentation;
import co.elastic.apm.agent.okhttp.OkHttpClientHelper;
import co.elastic.apm.agent.okhttp.OkHttpRequestHeaderGetter;
import co.elastic.apm.agent.okhttp.OkHttpRequestHeaderSetter;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class OkHttpClientInstrumentation
extends AbstractOkHttpClientInstrumentation {
    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.okhttp.OkHttpClientInstrumentation$OkHttpClientExecuteAdvice";
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.squareup.okhttp.Call");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.returns(ElementMatchers.named("com.squareup.okhttp.Response")));
    }

    public static class OkHttpClientExecuteAdvice {
        @Nonnull
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        @Advice.AssignReturned.ToFields(value={@Advice.AssignReturned.ToFields.ToField(index=0, value="originalRequest", typing=Assigner.Typing.DYNAMIC)})
        public static Object[] onBeforeExecute(@Advice.FieldValue(value="originalRequest") @Nullable Object originalRequest) {
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent == null || !(originalRequest instanceof Request)) {
                return new Object[]{originalRequest, null};
            }
            Request request = (Request)originalRequest;
            HttpUrl httpUrl = request.httpUrl();
            Span span = HttpClientHelper.startHttpClientSpan(parent, request.method(), httpUrl.toString(), httpUrl.scheme(), OkHttpClientHelper.computeHostName(httpUrl.host()), httpUrl.port());
            if (span != null) {
                span.activate();
            }
            if (!TraceContext.containsTraceContextTextHeaders(request, OkHttpRequestHeaderGetter.INSTANCE)) {
                Request.Builder builder = ((Request)originalRequest).newBuilder();
                if (span != null) {
                    span.propagateTraceContext(builder, OkHttpRequestHeaderSetter.INSTANCE);
                } else {
                    parent.propagateTraceContext(builder, OkHttpRequestHeaderSetter.INSTANCE);
                }
                request = builder.build();
            }
            return new Object[]{request, span};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Return @Nullable Response response, @Advice.Thrown @Nullable Throwable t, @Advice.Enter @Nonnull Object[] enter) {
            Span span = null;
            if (enter[1] instanceof Span) {
                span = (Span)enter[1];
            }
            if (span != null) {
                try {
                    if (response != null) {
                        int statusCode = response.code();
                        span.getContext().getHttp().withStatusCode(statusCode);
                    } else if (t != null) {
                        span.withOutcome(Outcome.FAILURE);
                    }
                    span.captureException(t);
                }
                finally {
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }
}

