/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics.builtin;

import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.metrics.DoubleSupplier;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricRegistry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmMemoryMetrics
extends AbstractLifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(JvmMemoryMetrics.class);

    @Override
    public void start(ElasticApmTracer tracer) {
        this.bindTo(tracer.getMetricRegistry());
    }

    void bindTo(MetricRegistry registry) {
        final MemoryMXBean platformMXBean = ManagementFactory.getPlatformMXBean(MemoryMXBean.class);
        registry.add("jvm.memory.heap.used", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return platformMXBean.getHeapMemoryUsage().getUsed();
            }
        });
        registry.add("jvm.memory.heap.committed", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return platformMXBean.getHeapMemoryUsage().getCommitted();
            }
        });
        registry.add("jvm.memory.heap.max", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return platformMXBean.getHeapMemoryUsage().getMax();
            }
        });
        registry.add("jvm.memory.non_heap.used", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return platformMXBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        registry.add("jvm.memory.non_heap.committed", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return platformMXBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        registry.add("jvm.memory.non_heap.max", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return platformMXBean.getNonHeapMemoryUsage().getMax();
            }
        });
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (final MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP) continue;
            Labels.Mutable memoryPoolTags = Labels.Mutable.of("name", memoryPoolMXBean.getName());
            try {
                registry.add("jvm.memory.heap.pool.used", memoryPoolTags, new DoubleSupplier(){

                    @Override
                    public double get() {
                        return memoryPoolMXBean.getUsage().getUsed();
                    }
                });
                registry.add("jvm.memory.heap.pool.committed", memoryPoolTags, new DoubleSupplier(){

                    @Override
                    public double get() {
                        return memoryPoolMXBean.getUsage().getCommitted();
                    }
                });
                registry.add("jvm.memory.heap.pool.max", memoryPoolTags, new DoubleSupplier(){

                    @Override
                    public double get() {
                        return memoryPoolMXBean.getUsage().getMax();
                    }
                });
            }
            catch (Exception e) {
                logger.error("Cannot fetch memory metrics of memory pool " + memoryPoolMXBean.getName(), e);
            }
        }
    }
}

