/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics.builtin;

import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.metrics.DoubleSupplier;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stagemonitor.util.StringUtils;

public class CGroupMetrics
extends AbstractLifecycleListener {
    private static final String PROC_SELF_CGROUP = "/proc/self/cgroup";
    private static final String PROC_SELF_MOUNTINFO = "/proc/self/mountinfo";
    private static final String DEFAULT_SYS_FS_CGROUP = "/sys/fs/cgroup";
    private static final String CGROUP1_MAX_MEMORY = "memory.limit_in_bytes";
    private static final String CGROUP1_USED_MEMORY = "memory.usage_in_bytes";
    private static final String CGROUP2_MAX_MEMORY = "memory.max";
    private static final String CGROUP2_USED_MEMORY = "memory.current";
    private static final String CGROUP_MEMORY_STAT = "memory.stat";
    private static final String CGROUP1_UNLIMITED = "9223372036854771712";
    private static final String CGROUP2_UNLIMITED = "max";
    static final Pattern MEMORY_CGROUP = Pattern.compile("^\\d+:memory:.*");
    static final Pattern CGROUP1_MOUNT_POINT = Pattern.compile("^\\d+? \\d+? .+? .+? (.*?) .*cgroup.*memory.*");
    static final Pattern CGROUP2_MOUNT_POINT = Pattern.compile("^\\d+? \\d+? .+? .+? (.*?) .*cgroup2.*cgroup.*");
    private static final Logger logger = LoggerFactory.getLogger(CGroupMetrics.class);
    @Nullable
    private final CgroupFiles cgroupFiles;

    public CGroupMetrics() {
        this(new File(PROC_SELF_CGROUP), new File(PROC_SELF_MOUNTINFO));
    }

    CGroupMetrics(File procSelfCgroup, File mountInfo) {
        this.cgroupFiles = this.findCgroupFiles(procSelfCgroup, mountInfo);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private CgroupFiles findCgroupFiles(File procSelfCgroup, File mountInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 25[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    String applyCgroupRegex(Pattern regex, String mountLine) {
        Matcher matcher = regex.matcher(mountLine);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Nullable
    private CgroupFiles createCgroup2Files(String cgroupLine, File rootCgroupFsPath) throws IOException {
        String[] cgroupLineParts = StringUtils.split(cgroupLine, ':');
        String sliceSubdir = cgroupLineParts[cgroupLineParts.length - 1];
        File maxMemoryFile = new File(rootCgroupFsPath, sliceSubdir + System.getProperty("file.separator") + CGROUP2_MAX_MEMORY);
        if (maxMemoryFile.canRead()) {
            maxMemoryFile = this.getMaxMemoryFile(maxMemoryFile, CGROUP2_UNLIMITED);
            return new CgroupFiles(maxMemoryFile, new File(rootCgroupFsPath, sliceSubdir + System.getProperty("file.separator") + CGROUP2_USED_MEMORY), new File(rootCgroupFsPath, sliceSubdir + System.getProperty("file.separator") + CGROUP_MEMORY_STAT));
        }
        return null;
    }

    @Nullable
    private CgroupFiles createCgroup1Files(File memoryMountPath) throws IOException {
        File maxMemoryFile = new File(memoryMountPath, CGROUP1_MAX_MEMORY);
        if (maxMemoryFile.canRead()) {
            maxMemoryFile = this.getMaxMemoryFile(maxMemoryFile, CGROUP1_UNLIMITED);
            return new CgroupFiles(maxMemoryFile, new File(memoryMountPath, CGROUP1_USED_MEMORY), new File(memoryMountPath, CGROUP_MEMORY_STAT));
        }
        return null;
    }

    @Nullable
    private File getMaxMemoryFile(File maxMemoryFile, String cgroupUnlimitedConstant) throws IOException {
        try (BufferedReader maxFileReader = new BufferedReader(new FileReader(maxMemoryFile));){
            String memMaxLine = maxFileReader.readLine();
            if (cgroupUnlimitedConstant.equalsIgnoreCase(memMaxLine)) {
                maxMemoryFile = null;
            }
        }
        return maxMemoryFile;
    }

    @Override
    public void start(ElasticApmTracer tracer) {
        this.bindTo(tracer.getMetricRegistry());
    }

    void bindTo(MetricRegistry metricRegistry) {
        if (this.cgroupFiles != null) {
            metricRegistry.addUnlessNan("system.process.cgroup.memory.mem.usage.bytes", Labels.EMPTY, new DoubleSupplier(){

                @Override
                public double get() {
                    double d;
                    BufferedReader fileReaderMemoryUsed = new BufferedReader(new FileReader(CGroupMetrics.this.cgroupFiles.getUsedMemoryFile()));
                    try {
                        d = Long.parseLong(fileReaderMemoryUsed.readLine());
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                fileReaderMemoryUsed.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            logger.debug("Failed to read " + CGroupMetrics.this.cgroupFiles.getUsedMemoryFile().getAbsolutePath() + " file", e);
                            return Double.NaN;
                        }
                    }
                    fileReaderMemoryUsed.close();
                    return d;
                }
            });
            final File maxMemoryFile = this.cgroupFiles.getMaxMemoryFile();
            if (maxMemoryFile != null) {
                metricRegistry.addUnlessNan("system.process.cgroup.memory.mem.limit.bytes", Labels.EMPTY, new DoubleSupplier(){

                    @Override
                    public double get() {
                        double d;
                        BufferedReader fileReaderMemoryMax = new BufferedReader(new FileReader(maxMemoryFile));
                        try {
                            d = Long.parseLong(fileReaderMemoryMax.readLine());
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    fileReaderMemoryMax.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                logger.debug("Failed to read " + maxMemoryFile + " file", e);
                                return Double.NaN;
                            }
                        }
                        fileReaderMemoryMax.close();
                        return d;
                    }
                });
            }
        }
    }

    private static class CgroupFiles {
        @Nullable
        private final File maxMemoryFile;
        private final File usedMemoryFile;
        private final File statMemoryFile;

        public CgroupFiles(@Nullable File maxMemoryFile, File usedMemoryFile, File statMemoryFile) {
            this.maxMemoryFile = maxMemoryFile;
            this.usedMemoryFile = usedMemoryFile;
            this.statMemoryFile = statMemoryFile;
        }

        @Nullable
        public File getMaxMemoryFile() {
            return this.maxMemoryFile;
        }

        public File getUsedMemoryFile() {
            return this.usedMemoryFile;
        }

        public File getStatMemoryFile() {
            return this.statMemoryFile;
        }
    }
}

