/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.matcher;

import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import javax.annotation.Nullable;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class AnnotationMatcher
extends ElementMatcher.Junction.AbstractBase<AnnotationSource> {
    @Nullable
    private final WildcardMatcher wildcardMatcher;
    private final boolean metaAnnotation;
    private final String annotationPattern;

    private AnnotationMatcher(String annotationPattern) {
        if (!annotationPattern.startsWith("@")) {
            throw new IllegalArgumentException("Invalid annotation pattern: " + annotationPattern);
        }
        this.annotationPattern = annotationPattern;
        this.metaAnnotation = annotationPattern.startsWith("@@");
        String wildcardPattern = annotationPattern.substring(this.metaAnnotation ? 2 : 1);
        this.wildcardMatcher = WildcardMatcher.valueOf(wildcardPattern);
    }

    private AnnotationMatcher() {
        this.wildcardMatcher = null;
        this.metaAnnotation = false;
        this.annotationPattern = "*";
    }

    public static AnnotationMatcher annotationMatcher(String annotationPattern) {
        return new AnnotationMatcher(annotationPattern);
    }

    public static AnnotationMatcher matchAll() {
        return new AnnotationMatcher();
    }

    @Override
    public boolean matches(AnnotationSource target) {
        if (this.matchesAll()) {
            return true;
        }
        ElementMatcher.Junction<AnnotationSource> resultMatcher = ElementMatchers.isAnnotatedWith(CustomElementMatchers.matches(this.wildcardMatcher));
        if (this.metaAnnotation) {
            resultMatcher = ElementMatchers.isAnnotatedWith(resultMatcher);
        }
        return resultMatcher.matches(target);
    }

    public String toString() {
        return "matches(" + this.annotationPattern + ")";
    }

    private boolean matchesAll() {
        return this.wildcardMatcher == null;
    }
}

