/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.lettuce;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.lettuce.Lettuce5StartSpanInstrumentation;
import io.lettuce.core.protocol.RedisCommand;
import java.util.Arrays;
import java.util.Collection;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Lettuce5StopSpanInstrumentation
extends TracerAwareInstrumentation {
    private static final Logger logger = LoggerFactory.getLogger(Lettuce5StopSpanInstrumentation.class);

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("io.lettuce").and(ElementMatchers.nameContains("Command"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.lettuce.core.protocol.RedisCommand"));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "lettuce");
    }

    public static class OnCancel
    extends Lettuce5StopSpanInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("cancel").and(ElementMatchers.takesArguments(0));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void beforeComplete(@Advice.This RedisCommand<?, ?, ?> command) {
                Span span;
                if (!command.isDone() && !command.isCancelled() && (span = Lettuce5StartSpanInstrumentation.commandToSpan.remove(command)) != null) {
                    logger.debug("Command#cancel");
                    span.end();
                }
            }
        }
    }

    public static class OnCompleteExceptionally
    extends Lettuce5StopSpanInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("completeExceptionally").and(ElementMatchers.takesArguments(Throwable.class));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void beforeComplete(@Advice.This RedisCommand<?, ?, ?> command, @Advice.Argument(value=0) Throwable throwable) {
                Span span;
                if (!command.isDone() && !command.isCancelled() && (span = Lettuce5StartSpanInstrumentation.commandToSpan.remove(command)) != null) {
                    logger.debug("Command#completeExceptionally");
                    ((Span)span.captureException(throwable)).end();
                }
            }
        }
    }

    public static class OnComplete
    extends Lettuce5StopSpanInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("complete").and(ElementMatchers.takesArguments(0));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void beforeComplete(@Advice.This RedisCommand<?, ?, ?> command) {
                Span span;
                if (!command.isDone() && !command.isCancelled() && (span = Lettuce5StartSpanInstrumentation.commandToSpan.remove(command)) != null) {
                    logger.debug("Command#complete");
                    span.end();
                }
            }
        }
    }
}

