/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka.helper;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.kafka.helper.ConsumerRecordsIterableWrapper;
import co.elastic.apm.agent.kafka.helper.ConsumerRecordsIteratorWrapper;
import co.elastic.apm.agent.kafka.helper.ConsumerRecordsListWrapper;
import co.elastic.apm.agent.kafka.helper.KafkaRecordHeaderAccessor;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaInstrumentationHeadersHelper {
    private static final Logger logger = LoggerFactory.getLogger(KafkaInstrumentationHeadersHelper.class);
    private static final KafkaInstrumentationHeadersHelper INSTANCE = new KafkaInstrumentationHeadersHelper(GlobalTracer.requireTracerImpl());
    private final ElasticApmTracer tracer;

    public static KafkaInstrumentationHeadersHelper get() {
        return INSTANCE;
    }

    public KafkaInstrumentationHeadersHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
    }

    public Iterator<ConsumerRecord<?, ?>> wrapConsumerRecordIterator(Iterator<ConsumerRecord<?, ?>> consumerRecordIterator) {
        try {
            return new ConsumerRecordsIteratorWrapper(consumerRecordIterator, this.tracer);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Kafka ConsumerRecords iterator", throwable);
            return consumerRecordIterator;
        }
    }

    public Iterable<ConsumerRecord<?, ?>> wrapConsumerRecordIterable(Iterable<ConsumerRecord<?, ?>> consumerRecordIterable) {
        try {
            return new ConsumerRecordsIterableWrapper(consumerRecordIterable, this.tracer);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Kafka ConsumerRecords", throwable);
            return consumerRecordIterable;
        }
    }

    public List<ConsumerRecord<?, ?>> wrapConsumerRecordList(List<ConsumerRecord<?, ?>> consumerRecordList) {
        try {
            return new ConsumerRecordsListWrapper(consumerRecordList, this.tracer);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Kafka ConsumerRecords list", throwable);
            return consumerRecordList;
        }
    }

    public void setOutgoingTraceContextHeaders(Span span, ProducerRecord<?, ?> producerRecord) {
        span.propagateTraceContext(producerRecord, KafkaRecordHeaderAccessor.instance());
    }

    public void removeTraceContextHeader(ProducerRecord<?, ?> producerRecord) {
        TraceContext.removeTraceContextHeaders(producerRecord, KafkaRecordHeaderAccessor.instance());
    }
}

