/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.kafka.BaseKafkaInstrumentation;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class KafkaConsumerInstrumentation
extends BaseKafkaInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.apache.kafka.clients.consumer.KafkaConsumer");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("poll").and(ElementMatchers.isPublic());
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.kafka.KafkaConsumerInstrumentation$KafkaConsumerAdvice";
    }

    public static class KafkaConsumerAdvice {
        private static final MessagingConfiguration messagingConfiguration = GlobalTracer.requireTracerImpl().getConfig(MessagingConfiguration.class);

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        @Nullable
        public static Object pollStart() {
            Transaction transaction;
            AbstractSpan<?> activeSpan = TracerAwareInstrumentation.tracer.getActive();
            if (activeSpan == null) {
                return null;
            }
            if (messagingConfiguration.shouldEndMessagingTransactionOnPoll() && activeSpan instanceof Transaction && "messaging".equals((transaction = (Transaction)activeSpan).getType())) {
                ((Transaction)transaction.deactivate()).end();
                return null;
            }
            Span span = activeSpan.createExitSpan();
            if (span == null) {
                return null;
            }
            span.withType("messaging").withSubtype("kafka").withAction("poll").withName("KafkaConsumer#poll", 100);
            span.getContext().getDestination().getService().withType("messaging").withName("kafka").withResource("kafka");
            span.activate();
            return span;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static void pollEnd(@Advice.Enter @Nullable Object spanObj, @Advice.Thrown Throwable throwable) {
            Span span = (Span)spanObj;
            if (span != null) {
                span.captureException(throwable);
                ((Span)span.deactivate()).end();
            }
        }
    }
}

