/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.impl.transaction.AbstractHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotWriteableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessagePropertyAccessor
extends AbstractHeaderGetter<String, Message>
implements TextHeaderGetter<Message>,
TextHeaderSetter<Message> {
    private static final Logger logger = LoggerFactory.getLogger(JmsMessagePropertyAccessor.class);
    private static final JmsMessagePropertyAccessor INSTANCE = new JmsMessagePropertyAccessor();

    public static JmsMessagePropertyAccessor instance() {
        return INSTANCE;
    }

    private JmsMessagePropertyAccessor() {
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, Message message) {
        headerName = this.jmsifyHeaderName(headerName);
        String value = null;
        try {
            value = message.getStringProperty(headerName);
        }
        catch (JMSException e) {
            logger.error("Failed to extract JMS message property {}", (Object)headerName, (Object)e);
        }
        return value;
    }

    @Nonnull
    private String jmsifyHeaderName(String headerName) {
        if (headerName.equals("elastic-apm-traceparent")) {
            headerName = JmsInstrumentationHelper.JMS_TRACE_PARENT_PROPERTY;
        }
        return headerName;
    }

    @Override
    public void setHeader(String headerName, String headerValue, Message message) {
        if (this.getFirstHeader(headerName = this.jmsifyHeaderName(headerName), message) != null) {
            return;
        }
        try {
            message.setStringProperty(headerName, headerValue);
        }
        catch (MessageNotWriteableException e) {
            logger.debug("Failed to set JMS message property {} due to read-only message", (Object)headerName, (Object)e);
        }
        catch (JMSException e) {
            logger.warn("Failed to set JMS message property {}. Distributed tracing may not work.", (Object)headerName);
            logger.debug("Detailed error: ", e);
        }
    }
}

