/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.helper;

import co.elastic.apm.agent.sdk.state.GlobalState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GlobalState
public class ConnectionMetaData {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionMetaData.class);
    private static final Map<String, ConnectionUrlParser> parsers = new HashMap<String, ConnectionUrlParser>();
    private final String dbVendor;
    @Nullable
    private final String host;
    private final int port;
    @Nullable
    private final String instance;
    private final String user;

    public static ConnectionMetaData create(String connectionUrl, @Nullable String instance, String user) {
        int indexOfNextColon;
        String dbVendor = "unknown";
        String tmpUrl = connectionUrl;
        int indexOfJdbc = tmpUrl.indexOf("jdbc:");
        if (indexOfJdbc != -1 && (indexOfNextColon = (tmpUrl = tmpUrl.substring(indexOfJdbc + 5)).indexOf(":")) != -1) {
            dbVendor = tmpUrl.substring(0, indexOfNextColon);
            tmpUrl = tmpUrl.substring(indexOfNextColon + 1);
        }
        ConnectionMetaData ret = null;
        ConnectionUrlParser connectionUrlParser = parsers.get(dbVendor);
        if (connectionUrlParser != null) {
            try {
                ret = connectionUrlParser.parse(tmpUrl, instance, user);
            }
            catch (Exception e) {
                logger.error("Failed to parse connection URL: " + tmpUrl, e);
            }
        } else {
            ret = ConnectionUrlParser.defaultParse(connectionUrl, dbVendor, -1, instance, user);
        }
        if (ret == null) {
            ret = new ConnectionMetaData(dbVendor, null, -1, instance, user);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Based on the connection URL {}, parsed metadata is: {}", (Object)connectionUrl, (Object)ret);
        }
        return ret;
    }

    private ConnectionMetaData(String dbVendor, @Nullable String host, int port, @Nullable String instance, String user) {
        this.dbVendor = dbVendor;
        this.host = host;
        this.port = port;
        this.instance = instance;
        this.user = user;
    }

    public String getDbVendor() {
        return this.dbVendor;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getInstance() {
        return this.instance;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return "ConnectionMetaData{dbVendor='" + this.dbVendor + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", instance='" + this.instance + '\'' + ", user='" + this.user + '\'' + '}';
    }

    static {
        for (ConnectionUrlParser parser : ConnectionUrlParser.values()) {
            parsers.put(parser.dbVendor, parser);
        }
    }

    private static enum ConnectionUrlParser {
        ORACLE("oracle"){
            public static final int DEFAULT_PORT = 1521;

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                int port;
                String host;
                block14: {
                    int indexOfUserDetailsEnd = connectionUrl.indexOf(64);
                    if (indexOfUserDetailsEnd > 0) {
                        if (connectionUrl.length() > indexOfUserDetailsEnd + 1) {
                            connectionUrl = connectionUrl.substring(indexOfUserDetailsEnd + 1).trim();
                        } else {
                            return new ConnectionMetaData(this.dbVendor, null, 1521, instance, user);
                        }
                    }
                    host = null;
                    port = 1521;
                    if (connectionUrl.startsWith("(")) {
                        try {
                            HostPort hostPort = this.parseAddressList(connectionUrl);
                            if (hostPort == null) break block14;
                            host = hostPort.host;
                            if (hostPort.port > 0) {
                                port = hostPort.port;
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Failed to parse address from this address list: {}", (Object)connectionUrl);
                            port = -1;
                        }
                    } else {
                        HostPort hostPort = 1.parseHostPort(connectionUrl);
                        if (hostPort.host != null) {
                            host = hostPort.host;
                            if (hostPort.port > 0) {
                                port = hostPort.port;
                            }
                        } else {
                            String[] parts;
                            if (connectionUrl.startsWith("thin:")) {
                                connectionUrl = connectionUrl.substring("thin:".length());
                            }
                            if ((parts = connectionUrl.split(":")).length > 0) {
                                host = parts[0];
                            }
                            if (parts.length > 1) {
                                port = 1.toNumericPort(connectionUrl, parts[1], 1521);
                            }
                        }
                    }
                }
                return new ConnectionMetaData(this.dbVendor, host, port, instance, user);
            }

            @Nullable
            private HostPort parseAddressList(String connectionUrl) {
                TreeNode parsedTree = null;
                ArrayDeque<TreeNode> stack = new ArrayDeque<TreeNode>();
                StringBuilder currentValueBuffer = null;
                block5: for (char c : connectionUrl.toLowerCase().toCharArray()) {
                    switch (c) {
                        case '(': {
                            TreeNode treeNode = new TreeNode();
                            if (stack.isEmpty()) {
                                parsedTree = treeNode;
                            } else {
                                ((TreeNode)stack.peek()).childNodes.add(treeNode);
                            }
                            stack.push(treeNode);
                            currentValueBuffer = treeNode.name;
                            continue block5;
                        }
                        case ')': {
                            stack.pop();
                        }
                        case '=': {
                            if (stack.isEmpty()) {
                                currentValueBuffer = null;
                                continue block5;
                            }
                            currentValueBuffer = ((TreeNode)stack.peek()).value;
                            continue block5;
                        }
                        default: {
                            if (currentValueBuffer == null) {
                                logger.warn("Failed to parse Oracle DB address list from: {}", (Object)connectionUrl);
                                continue block5;
                            }
                            currentValueBuffer.append(c);
                        }
                    }
                }
                HostPort ret = null;
                if (parsedTree == null) {
                    logger.warn("Failed to parse Oracle DB address list from: {}", (Object)connectionUrl);
                } else {
                    ret = this.findAddressInTree(connectionUrl, parsedTree);
                }
                return ret;
            }

            @Nullable
            HostPort findAddressInTree(String connectionUrl, TreeNode treeNode) {
                TreeNode childNode;
                if (treeNode.name.toString().trim().equals("address")) {
                    String host = null;
                    int port = -1;
                    for (TreeNode childNode2 : treeNode.childNodes) {
                        String name = childNode2.name.toString().trim();
                        if (name.equals("host")) {
                            host = childNode2.value.toString().trim();
                            continue;
                        }
                        if (!name.equals("port")) continue;
                        port = 1.toNumericPort(connectionUrl, childNode2.value.toString().trim());
                    }
                    if (host != null) {
                        return new HostPort(host, port);
                    }
                }
                HostPort ret = null;
                Iterator<TreeNode> iterator = treeNode.childNodes.iterator();
                while (iterator.hasNext() && (ret = this.findAddressInTree(connectionUrl, childNode = iterator.next())) == null) {
                }
                return ret;
            }

            class TreeNode {
                StringBuilder name = new StringBuilder();
                StringBuilder value = new StringBuilder();
                List<TreeNode> childNodes = new ArrayList<TreeNode>();

                TreeNode() {
                }
            }
        }
        ,
        POSTGRESQL("postgresql"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, 5432, instance, user);
            }
        }
        ,
        MYSQL("mysql"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                String host = "localhost";
                int port = 3306;
                HostPort hostPort = 3.parseMySqlFlavor(connectionUrl);
                if (hostPort != null) {
                    host = hostPort.host;
                    if (hostPort.port > 0) {
                        port = hostPort.port;
                    }
                }
                return new ConnectionMetaData(this.dbVendor, host, port, instance, user);
            }
        }
        ,
        DB2("db2"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, 50000, instance, user);
            }
        }
        ,
        H2("h2"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, -1, instance, user);
            }
        }
        ,
        DERBY("derby"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, 1527, instance, user);
            }
        }
        ,
        HSQLDB("hsqldb"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, 9001, instance, user);
            }
        }
        ,
        MARIADB("mariadb"){
            final List<String> SPECIALIZED_PROTOCOL_STRINGS = new ArrayList<String>(Arrays.asList("sequential:", "loadbalance:", "failover:", "replication:", "aurora:"));

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                HostPort hostPort;
                String host = "localhost";
                int port = 3306;
                for (String protocol : this.SPECIALIZED_PROTOCOL_STRINGS) {
                    int indexOfProtocol = connectionUrl.indexOf(protocol);
                    if (indexOfProtocol < 0) continue;
                    connectionUrl = connectionUrl.substring(indexOfProtocol + protocol.length());
                }
                if (!connectionUrl.contains("//")) {
                    connectionUrl = "//" + connectionUrl;
                }
                if ((hostPort = 8.parseMySqlFlavor(connectionUrl)) != null) {
                    host = hostPort.host;
                    if (hostPort.port > 0) {
                        port = hostPort.port;
                    }
                }
                return new ConnectionMetaData(this.dbVendor, host, port, instance, user);
            }
        }
        ,
        SQLSERVER("sqlserver"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                int indexOfInstance;
                String host = "localhost";
                int port = 1433;
                int indexOfProperties = connectionUrl.indexOf(59);
                if (indexOfProperties > 0) {
                    if (connectionUrl.length() > indexOfProperties + 1) {
                        String[] properties;
                        String propertiesPart = connectionUrl.substring(indexOfProperties + 1);
                        for (String property : properties = propertiesPart.split(";")) {
                            String[] parts = property.split("=");
                            if (parts.length != 2 || !parts[0].equals("serverName")) continue;
                            host = parts[1];
                        }
                    }
                    connectionUrl = connectionUrl.substring(0, indexOfProperties);
                }
                HostPort hostPort = 9.parseHostPort(connectionUrl);
                if (hostPort.host != null) {
                    host = hostPort.host;
                    if (hostPort.port > 0) {
                        port = hostPort.port;
                    }
                }
                if ((indexOfInstance = host.indexOf(92)) > 0) {
                    host = host.substring(0, indexOfInstance);
                }
                return new ConnectionMetaData("mssql", host, port, instance, user);
            }
        }
        ,
        UNKNOWN("unknown"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String instance, String user) {
                return new ConnectionMetaData(this.dbVendor, null, -1, instance, user);
            }
        };

        final String dbVendor;

        private ConnectionUrlParser(String dbVendor) {
            this.dbVendor = dbVendor;
        }

        abstract ConnectionMetaData parse(String var1, String var2, String var3);

        static ConnectionMetaData defaultParse(String connectionUrl, String dbVendor, int defaultPort, @Nullable String instance, String user) {
            int indexOfProperties = connectionUrl.indexOf(59);
            if (indexOfProperties > 0) {
                connectionUrl = connectionUrl.substring(0, indexOfProperties);
            }
            String host = "localhost";
            int port = -1;
            HostPort hostPort = ConnectionUrlParser.parseHostPort(connectionUrl);
            if (hostPort.host != null) {
                host = hostPort.host;
                port = hostPort.port > 0 ? hostPort.port : defaultPort;
            }
            return new ConnectionMetaData(dbVendor, host, port, instance, user);
        }

        static HostPort parseHostPort(String url) {
            int indexOfDoubleSlash;
            if (url.length() > 0 && (indexOfDoubleSlash = url.indexOf("//")) >= 0 && url.length() > indexOfDoubleSlash + 2) {
                if ((url = url.substring(indexOfDoubleSlash + 2)).length() == 1) {
                    return new HostPort("localhost", -1);
                }
                return ConnectionUrlParser.parseAuthority(url);
            }
            return new HostPort(null, -1);
        }

        static HostPort parseAuthority(String url) {
            String host;
            int lastIndexOfColon;
            int indexOfSlash;
            int indexOrProperties = url.indexOf(63);
            if (indexOrProperties > 0) {
                url = url.substring(0, indexOrProperties);
            }
            String hostPort = (indexOfSlash = url.indexOf(47)) > 0 ? url.substring(0, indexOfSlash) : url;
            int port = -1;
            int indexOfColon = hostPort.indexOf(58);
            if (indexOfColon > 0 && indexOfColon != (lastIndexOfColon = hostPort.lastIndexOf(58))) {
                int indexOfIpv6End = hostPort.indexOf(93);
                indexOfColon = indexOfIpv6End > 0 && hostPort.length() > indexOfIpv6End + 1 ? indexOfIpv6End + 1 : -1;
            }
            if (indexOfColon > 0) {
                host = hostPort.substring(0, indexOfColon);
                if (hostPort.length() > indexOfColon + 1) {
                    port = ConnectionUrlParser.toNumericPort(url, hostPort.substring(indexOfColon + 1));
                }
            } else {
                host = hostPort;
            }
            return new HostPort(host, port);
        }

        static int toNumericPort(String url, String portString) {
            return ConnectionUrlParser.toNumericPort(url, portString, -1);
        }

        static int toNumericPort(String url, String portString, int defaultPort) {
            int port = defaultPort;
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                logger.debug("Port parsed from the connection string {} is not a number - {}", (Object)url, (Object)portString);
            }
            return port;
        }

        @Nullable
        static HostPort parseMySqlFlavor(String connectionUrl) {
            HostPort ret = null;
            connectionUrl = connectionUrl.toLowerCase().trim();
            Pattern pattern = Pattern.compile("//([^/?]+)");
            Matcher matcher = pattern.matcher(connectionUrl);
            if (matcher.find()) {
                int indexOfUserDetailsEnd;
                String addressKey;
                String hostsPart = matcher.group(1);
                ArrayList<String> hosts = new ArrayList<String>();
                String[] parts = hostsPart.toLowerCase().trim().split(",");
                StringBuilder sb = new StringBuilder();
                for (String part : parts) {
                    if (part.lastIndexOf(41) < part.lastIndexOf(40)) {
                        sb.append(part).append(',');
                        continue;
                    }
                    boolean isWithinKeyValuePart = sb.length() > 0;
                    sb.append(part);
                    if (isWithinKeyValuePart && !part.contains(")")) {
                        sb.append(',');
                        continue;
                    }
                    hosts.add(sb.toString());
                    sb.setLength(0);
                }
                String firstHost = (String)hosts.get(0);
                int indexOfAddress = firstHost.indexOf(addressKey = "address=");
                if (indexOfAddress >= 0) {
                    String tmp = firstHost.substring(indexOfAddress + addressKey.length());
                    Matcher hostMatcher = Pattern.compile("\\s*host\\s*=\\s*([^)]+)\\s*").matcher(tmp);
                    if (hostMatcher.find()) {
                        String host = hostMatcher.group(1).trim();
                        int port = -1;
                        Matcher portMatcher = Pattern.compile("\\s*port\\s*=\\s*([^)]+)\\s*").matcher(tmp);
                        if (portMatcher.find()) {
                            port = ConnectionUrlParser.toNumericPort(connectionUrl, portMatcher.group(1).trim());
                        }
                        return new HostPort(host, port);
                    }
                    logger.warn("Failed to parse address from a connection URL: {}", (Object)connectionUrl);
                    return null;
                }
                Matcher keyValueMatcher = Pattern.compile("\\(([^)]+)\\)").matcher(firstHost);
                if (keyValueMatcher.find()) {
                    String keyValuePart = keyValueMatcher.group(1).trim();
                    parts = keyValuePart.split(",");
                    String host = null;
                    int port = -1;
                    for (String part : parts) {
                        String[] keyValue = part.split("=");
                        if (keyValue.length != 2) continue;
                        if (keyValue[0].trim().equals("host")) {
                            host = keyValue[1].trim();
                            continue;
                        }
                        if (!keyValue[0].trim().equals("port")) continue;
                        port = ConnectionUrlParser.toNumericPort(connectionUrl, keyValue[1].trim());
                    }
                    if (host != null) {
                        return new HostPort(host, port);
                    }
                    logger.warn("Failed to parse address from a connection URL: {}", (Object)connectionUrl);
                    return null;
                }
                int indexOfSquareBracket = firstHost.indexOf(91);
                if (!(indexOfSquareBracket < 0 || firstHost.contains("]") && firstHost.lastIndexOf(91) == indexOfSquareBracket)) {
                    firstHost = firstHost.substring(indexOfSquareBracket + 1);
                }
                if ((indexOfUserDetailsEnd = firstHost.indexOf(64)) >= 0) {
                    if (firstHost.length() > indexOfUserDetailsEnd + 1) {
                        firstHost = firstHost.substring(indexOfUserDetailsEnd + 1).trim();
                    } else {
                        return null;
                    }
                }
                ret = ConnectionUrlParser.parseAuthority(firstHost.trim());
            }
            return ret;
        }

        static class HostPort {
            @Nullable
            String host;
            int port;

            public HostPort(@Nullable String host, int port) {
                this.host = host;
                this.port = port;
            }
        }
    }
}

