/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.metadata;

import co.elastic.apm.agent.impl.metadata.ProcessInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public interface ProcessFactory {
    public ProcessInfo getProcessInformation();

    @IgnoreJRERequirement
    public static class ForJava9CompatibleVM
    implements ProcessFactory {
        private final Object processHandle;

        ForJava9CompatibleVM(Method current) {
            try {
                this.processHandle = current.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Can't access ProcessHandle#current", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Can't invoke ProcessHandle#current", e);
            }
        }

        static ProcessFactory make() throws Exception {
            return new ForJava9CompatibleVM(Class.forName("java.lang.ProcessHandle").getMethod("current", new Class[0]));
        }

        @Override
        public ProcessInfo getProcessInformation() {
            ProcessHandle processHandle = (ProcessHandle)this.processHandle;
            ProcessInfo process = new ProcessInfo(processHandle.info().command().orElse("unknown"));
            process.withPid(processHandle.pid());
            process.withPpid(processHandle.parent().map(new Function<ProcessHandle, Long>(){

                @Override
                public Long apply(ProcessHandle processHandle1) {
                    return processHandle1.pid();
                }
            }).orElse(null));
            process.withArgv(processHandle.info().arguments().map(new Function<String[], List<String>>(){

                @Override
                public List<String> apply(String[] a) {
                    return Arrays.asList(a);
                }
            }).orElse(null));
            return process;
        }
    }

    public static enum ForLegacyVM implements ProcessFactory
    {
        INSTANCE;

        private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();

        @Override
        public ProcessInfo getProcessInformation() {
            ProcessInfo process = new ProcessInfo(this.getTitle());
            process.withPid(this.getPid());
            process.withArgv(this.runtimeMXBean.getInputArguments());
            return process;
        }

        private String getTitle() {
            String javaHome = System.getProperty("java.home");
            String title = javaHome + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "java";
            if (System.getProperty("os.name").startsWith("Win")) {
                return title + ".exe";
            }
            return title;
        }

        private int getPid() {
            String pidAtHost = this.runtimeMXBean.getName();
            Matcher matcher = Pattern.compile("(\\d+)@.*").matcher(pidAtHost);
            if (matcher.matches()) {
                return Integer.parseInt(matcher.group(1));
            }
            return 0;
        }
    }

    public static enum ForCurrentVM implements ProcessFactory
    {
        INSTANCE;

        private final ProcessFactory dispatcher;

        private ForCurrentVM() {
            ProcessFactory processFactory;
            try {
                processFactory = ForJava9CompatibleVM.make();
            }
            catch (Exception | NoClassDefFoundError ignore) {
                processFactory = ForLegacyVM.INSTANCE;
            }
            this.dispatcher = processFactory;
        }

        @Override
        public ProcessInfo getProcessInformation() {
            return this.dispatcher.getProcessInformation();
        }
    }
}

