/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.report.processor.Processor;
import org.stagemonitor.configuration.ConfigurationRegistry;

public class BodyProcessor
implements Processor {
    private final CoreConfiguration coreConfiguration;

    public BodyProcessor(ConfigurationRegistry configurationRegistry) {
        this.coreConfiguration = configurationRegistry.getConfig(CoreConfiguration.class);
    }

    @Override
    public void processBeforeReport(Transaction transaction) {
        this.redactBodyIfNecessary(transaction.getContext(), CoreConfiguration.EventType.TRANSACTIONS);
    }

    @Override
    public void processBeforeReport(ErrorCapture error) {
        this.redactBodyIfNecessary(error.getContext(), CoreConfiguration.EventType.ERRORS);
    }

    private void redactBodyIfNecessary(TransactionContext context, CoreConfiguration.EventType eventType) {
        CoreConfiguration.EventType eventTypeConfig = this.coreConfiguration.getCaptureBody();
        if (eventTypeConfig != eventType && eventTypeConfig != CoreConfiguration.EventType.ALL) {
            if (context.getRequest().getBody() != null) {
                context.getRequest().redactBody();
            }
            context.getMessage().redactBody();
        }
    }
}

