/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.NoopTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.BinaryHeaderGetter;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.util.VersionUtils;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;

public class GlobalTracer
implements Tracer {
    private static final GlobalTracer INSTANCE = new GlobalTracer();
    private volatile Tracer tracer = NoopTracer.INSTANCE;
    private static volatile boolean classloaderCheckOk = false;

    private GlobalTracer() {
    }

    public static Tracer get() {
        return INSTANCE;
    }

    @Nullable
    public static ElasticApmTracer getTracerImpl() {
        Tracer tracer = GlobalTracer.INSTANCE.tracer;
        if (tracer instanceof ElasticApmTracer) {
            return (ElasticApmTracer)tracer;
        }
        return null;
    }

    public static ElasticApmTracer requireTracerImpl() {
        return Objects.requireNonNull(GlobalTracer.getTracerImpl(), "Registered tracer is not an instance of ElasticApmTracer");
    }

    private static void checkClassloader() {
        ClassLoader cl = GlobalTracer.class.getClassLoader();
        if (cl == null) {
            return;
        }
        if (classloaderCheckOk) {
            return;
        }
        String agentLocation = GlobalTracer.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (!agentLocation.endsWith(".jar")) {
            classloaderCheckOk = true;
            return;
        }
        String premainClass = VersionUtils.getManifestEntry(new File(agentLocation), "Premain-Class");
        if (null == premainClass) {
            classloaderCheckOk = true;
            return;
        }
        if (premainClass.startsWith("co.elastic.apm.agent")) {
            classloaderCheckOk = true;
            return;
        }
        throw new IllegalStateException(String.format("Agent setup error: agent jar file \"%s\"  likely referenced in JVM or application classpath", agentLocation));
    }

    public static synchronized void setNoop() {
        Tracer.TracerState currentTracerState = GlobalTracer.INSTANCE.tracer.getState();
        if (currentTracerState != Tracer.TracerState.UNINITIALIZED && currentTracerState != Tracer.TracerState.STOPPED) {
            throw new IllegalStateException("Can't override tracer as current tracer is already running");
        }
        GlobalTracer.INSTANCE.tracer = NoopTracer.INSTANCE;
    }

    public static synchronized void init(Tracer tracer) {
        if (!GlobalTracer.isNoop()) {
            throw new IllegalStateException("Tracer is already initialized");
        }
        GlobalTracer.INSTANCE.tracer = tracer;
    }

    public static boolean isNoop() {
        return GlobalTracer.INSTANCE.tracer == NoopTracer.INSTANCE;
    }

    @Override
    @Nullable
    public Transaction startRootTransaction(@Nullable ClassLoader initiatingClassLoader) {
        return this.tracer.startRootTransaction(initiatingClassLoader);
    }

    @Override
    @Nullable
    public Transaction startRootTransaction(@Nullable ClassLoader initiatingClassLoader, long epochMicro) {
        return this.tracer.startRootTransaction(initiatingClassLoader, epochMicro);
    }

    @Override
    @Nullable
    public Transaction startRootTransaction(Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        return this.tracer.startRootTransaction(sampler, epochMicros, initiatingClassLoader);
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, TextHeaderGetter<C> textHeadersGetter, @Nullable ClassLoader initiatingClassLoader) {
        return this.tracer.startChildTransaction(headerCarrier, textHeadersGetter, initiatingClassLoader);
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, TextHeaderGetter<C> textHeadersGetter, @Nullable ClassLoader initiatingClassLoader, long epochMicros) {
        return this.tracer.startChildTransaction(headerCarrier, textHeadersGetter, initiatingClassLoader, epochMicros);
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, TextHeaderGetter<C> textHeadersGetter, Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        return this.tracer.startChildTransaction(headerCarrier, textHeadersGetter, sampler, epochMicros, initiatingClassLoader);
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, BinaryHeaderGetter<C> binaryHeadersGetter, @Nullable ClassLoader initiatingClassLoader) {
        return this.tracer.startChildTransaction(headerCarrier, binaryHeadersGetter, initiatingClassLoader);
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, BinaryHeaderGetter<C> binaryHeadersGetter, Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        return this.tracer.startChildTransaction(headerCarrier, binaryHeadersGetter, sampler, epochMicros, initiatingClassLoader);
    }

    @Override
    @Nullable
    public Transaction currentTransaction() {
        return this.tracer.currentTransaction();
    }

    @Override
    @Nullable
    public AbstractSpan<?> getActive() {
        return this.tracer.getActive();
    }

    @Override
    @Nullable
    public Span getActiveSpan() {
        return this.tracer.getActiveSpan();
    }

    @Override
    public void captureAndReportException(@Nullable Throwable e, ClassLoader initiatingClassLoader) {
        this.tracer.captureAndReportException(e, initiatingClassLoader);
    }

    @Override
    @Nullable
    public String captureAndReportException(long epochMicros, @Nullable Throwable e, @Nullable AbstractSpan<?> parent) {
        return this.tracer.captureAndReportException(epochMicros, e, parent);
    }

    @Override
    @Nullable
    public ErrorCapture captureException(@Nullable Throwable e, @Nullable AbstractSpan<?> parent, @Nullable ClassLoader initiatingClassLoader) {
        return this.tracer.captureException(e, parent, initiatingClassLoader);
    }

    @Override
    @Nullable
    public Span getActiveExitSpan() {
        return this.tracer.getActiveExitSpan();
    }

    @Override
    public Tracer.TracerState getState() {
        return this.tracer.getState();
    }

    @Override
    public void overrideServiceNameForClassLoader(@Nullable ClassLoader classLoader, @Nullable String serviceName) {
        this.tracer.overrideServiceNameForClassLoader(classLoader, serviceName);
    }

    @Override
    public void stop() {
        this.tracer.stop();
    }

    @Override
    public boolean isRunning() {
        return this.tracer.isRunning();
    }

    @Override
    @Nullable
    public Span createExitChildSpan() {
        return this.tracer.createExitChildSpan();
    }

    static {
        GlobalTracer.checkClassloader();
    }
}

