/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl;

import co.elastic.apm.agent.configuration.AgentArgumentsConfigurationSource;
import co.elastic.apm.agent.configuration.ApmServerConfigurationSource;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.PrefixingConfigurationSourceWrapper;
import co.elastic.apm.agent.configuration.source.ConfigSources;
import co.elastic.apm.agent.configuration.source.PropertyFileConfigurationSource;
import co.elastic.apm.agent.configuration.source.SystemPropertyConfigurationSource;
import co.elastic.apm.agent.context.ClosableLifecycleListenerAdapter;
import co.elastic.apm.agent.context.LifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.metadata.MetaData;
import co.elastic.apm.agent.impl.metadata.MetaDataFuture;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.logging.LoggingConfiguration;
import co.elastic.apm.agent.objectpool.ObjectPoolFactory;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ReporterFactory;
import co.elastic.apm.agent.report.serialize.DslJsonSerializer;
import co.elastic.apm.agent.util.DependencyInjectingServiceLoader;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stagemonitor.configuration.ConfigurationOptionProvider;
import org.stagemonitor.configuration.ConfigurationRegistry;
import org.stagemonitor.configuration.source.ConfigurationSource;
import org.stagemonitor.configuration.source.EnvironmentVariableConfigurationSource;
import org.stagemonitor.configuration.source.SimpleSource;

public class ElasticApmTracerBuilder {
    private static final String TEMP_PROPERTIES_FILE_KEY = "c";
    private final Logger logger;
    private final String ephemeralId;
    @Nullable
    private ConfigurationRegistry configurationRegistry;
    @Nullable
    private Reporter reporter;
    private ObjectPoolFactory objectPoolFactory;
    private final List<LifecycleListener> extraLifecycleListeners;
    private final List<ConfigurationSource> configSources;

    public ElasticApmTracerBuilder() {
        this(ElasticApmTracerBuilder.getConfigSources(null, false));
    }

    public ElasticApmTracerBuilder(List<ConfigurationSource> configSources) {
        this.configSources = configSources;
        this.ephemeralId = UUID.randomUUID().toString();
        LoggingConfiguration.init(configSources, this.ephemeralId);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.objectPoolFactory = new ObjectPoolFactory();
        this.extraLifecycleListeners = new ArrayList<LifecycleListener>();
    }

    public ElasticApmTracerBuilder configurationRegistry(ConfigurationRegistry configurationRegistry) {
        this.configurationRegistry = configurationRegistry;
        return this;
    }

    public ElasticApmTracerBuilder reporter(Reporter reporter) {
        this.reporter = reporter;
        return this;
    }

    public ElasticApmTracerBuilder withObjectPoolFactory(ObjectPoolFactory objectPoolFactory) {
        this.objectPoolFactory = objectPoolFactory;
        return this;
    }

    public ElasticApmTracerBuilder withLifecycleListener(LifecycleListener listener) {
        this.extraLifecycleListeners.add(listener);
        return this;
    }

    public ElasticApmTracer build() {
        return this.build(false);
    }

    public ElasticApmTracer buildAndStart() {
        return this.build(true);
    }

    private ElasticApmTracer build(boolean startTracer) {
        boolean addApmServerConfigSource = false;
        ArrayList<LifecycleListener> lifecycleListeners = new ArrayList<LifecycleListener>();
        if (this.configurationRegistry == null) {
            addApmServerConfigSource = true;
            this.configurationRegistry = this.getDefaultConfigurationRegistry(this.configSources);
            lifecycleListeners.add(this.scheduleReloadAtRate(this.configurationRegistry, 30, TimeUnit.SECONDS));
        }
        ApmServerClient apmServerClient = new ApmServerClient(this.configurationRegistry.getConfig(ReporterConfiguration.class), this.configurationRegistry.getConfig(CoreConfiguration.class));
        MetaDataFuture metaDataFuture = MetaData.create(this.configurationRegistry, this.ephemeralId);
        if (addApmServerConfigSource) {
            DslJsonSerializer payloadSerializer = new DslJsonSerializer(this.configurationRegistry.getConfig(StacktraceConfiguration.class), apmServerClient, metaDataFuture);
            ApmServerConfigurationSource configurationSource = new ApmServerConfigurationSource(payloadSerializer, apmServerClient);
            this.configurationRegistry.addConfigurationSource(configurationSource);
            lifecycleListeners.add(configurationSource);
        }
        if (this.reporter == null) {
            this.reporter = new ReporterFactory().createReporter(this.configurationRegistry, apmServerClient, metaDataFuture);
        }
        ElasticApmTracer tracer = new ElasticApmTracer(this.configurationRegistry, this.reporter, this.objectPoolFactory, apmServerClient, this.ephemeralId, metaDataFuture);
        lifecycleListeners.addAll(DependencyInjectingServiceLoader.load(LifecycleListener.class, tracer));
        lifecycleListeners.addAll(this.extraLifecycleListeners);
        tracer.init(lifecycleListeners);
        if (startTracer) {
            tracer.start(false);
        }
        return tracer;
    }

    private LifecycleListener scheduleReloadAtRate(final ConfigurationRegistry configurationRegistry, final int rate, TimeUnit seconds) {
        final ScheduledThreadPoolExecutor configurationReloader = ExecutorUtils.createSingleThreadSchedulingDaemonPool("configuration-reloader");
        configurationReloader.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ElasticApmTracerBuilder.this.logger.debug("Beginning scheduled configuration reload (interval is {} sec)...", (Object)rate);
                configurationRegistry.reloadDynamicConfigurationOptions();
                ElasticApmTracerBuilder.this.logger.debug("Finished scheduled configuration reload");
            }
        }, rate, rate, seconds);
        return ClosableLifecycleListenerAdapter.of(new Closeable(){

            @Override
            public void close() {
                configurationReloader.shutdown();
            }
        });
    }

    private ConfigurationRegistry getDefaultConfigurationRegistry(List<ConfigurationSource> configSources) {
        List<ConfigurationOptionProvider> providers = DependencyInjectingServiceLoader.load(ConfigurationOptionProvider.class, new Object[0]);
        try {
            return ConfigurationRegistry.builder().configSources(configSources).optionProviders(providers).failOnMissingRequiredValues(true).build();
        }
        catch (IllegalStateException e) {
            this.logger.warn(e.getMessage());
            return ConfigurationRegistry.builder().addConfigSource(new SimpleSource("Noop Configuration").add("recording", "false").add("instrument", "false").add("service_name", "none").add("transaction_sample_rate", "0")).optionProviders(providers).build();
        }
    }

    public static List<ConfigurationSource> getConfigSources(@Nullable String agentArguments, boolean premain) {
        SimpleSource classpathSource;
        String configFileLocation;
        PropertyFileConfigurationSource configFileSource;
        AgentArgumentsConfigurationSource agentArgs;
        SimpleSource attachmentConfig;
        ArrayList<ConfigurationSource> result = new ArrayList<ConfigurationSource>();
        result.add(new PrefixingConfigurationSourceWrapper(new SystemPropertyConfigurationSource(), "elastic.apm."));
        result.add(new PrefixingConfigurationSourceWrapper(new EnvironmentVariableConfigurationSource(), "ELASTIC_APM_"));
        if (agentArguments != null && !agentArguments.isEmpty() && (attachmentConfig = ConfigSources.fromRuntimeAttachParameters((agentArgs = AgentArgumentsConfigurationSource.parse(agentArguments)).getValue(TEMP_PROPERTIES_FILE_KEY))) != null) {
            result.add(attachmentConfig);
        }
        if ((configFileSource = ConfigSources.fromFileSystem(configFileLocation = CoreConfiguration.getConfigFileLocation(result, premain))) != null) {
            result.add(0, configFileSource);
        }
        if ((classpathSource = ConfigSources.fromClasspath("elasticapm.properties", ClassLoader.getSystemClassLoader())) != null) {
            result.add(classpathSource);
        }
        return result;
    }
}

