/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpserver;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.httpserver.CookieHelper;
import co.elastic.apm.agent.httpserver.HeadersHeaderGetter;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.util.TransactionNameUtils;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandlerAdvice {
    private static final Logger logger = LoggerFactory.getLogger(HttpHandlerAdvice.class);

    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
    public static Object onEnterHandle(@Advice.Argument(value=0) HttpExchange exchange) {
        Headers headers;
        ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
        if (tracer == null) {
            return null;
        }
        WebConfiguration webConfiguration = tracer.getConfig(WebConfiguration.class);
        if (tracer.currentTransaction() != null || HttpHandlerAdvice.isExcluded(webConfiguration, exchange.getRequestURI().getPath(), exchange.getRequestHeaders().getFirst("User-Agent"))) {
            return null;
        }
        Transaction transaction = tracer.startChildTransaction(exchange.getRequestHeaders(), HeadersHeaderGetter.INSTANCE, Thread.currentThread().getContextClassLoader());
        if (transaction == null) {
            return null;
        }
        TransactionNameUtils.setNameFromHttpRequestPath(exchange.getRequestMethod(), exchange.getRequestURI().getPath(), transaction.getAndOverrideName(10), webConfiguration.getUrlGroups());
        transaction.withType("request").setFrameworkName("JDK HTTP Server");
        Request request = transaction.getContext().getRequest();
        request.getSocket().withRemoteAddress(exchange.getRemoteAddress().getAddress().getHostAddress());
        request.withHttpVersion(exchange.getProtocol()).withMethod(exchange.getRequestMethod());
        request.getUrl().withProtocol(exchange instanceof HttpsExchange ? "https" : "http").withHostname(HttpHandlerAdvice.getHostname(exchange)).withPort(exchange.getLocalAddress().getPort()).withPathname(exchange.getRequestURI().getPath()).withSearch(exchange.getRequestURI().getQuery());
        CoreConfiguration coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        if (transaction.isSampled() && coreConfiguration.isCaptureHeaders() && (headers = exchange.getRequestHeaders()) != null) {
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                if ("Cookie".equalsIgnoreCase(header.getKey())) {
                    for (String[] cookie : CookieHelper.getCookies(header.getValue())) {
                        request.addCookie(cookie[0], cookie[1]);
                    }
                    continue;
                }
                request.addHeader(header.getKey(), Collections.enumeration((Collection)header.getValue()));
            }
        }
        return transaction.activate();
    }

    public static boolean isExcluded(WebConfiguration webConfiguration, String requestPath, @Nullable String userAgentHeader) {
        boolean isExcluded;
        WildcardMatcher excludeAgentMatcher;
        WildcardMatcher excludeUrlMatcher = WildcardMatcher.anyMatch(webConfiguration.getIgnoreUrls(), requestPath);
        if (excludeUrlMatcher != null) {
            logger.debug("Not tracing this request as the URL {} is ignored by the matcher {}", (Object)requestPath, (Object)excludeUrlMatcher);
        }
        WildcardMatcher wildcardMatcher = excludeAgentMatcher = userAgentHeader != null ? WildcardMatcher.anyMatch(webConfiguration.getIgnoreUserAgents(), userAgentHeader) : null;
        if (excludeAgentMatcher != null) {
            logger.debug("Not tracing this request as the User-Agent {} is ignored by the matcher {}", (Object)userAgentHeader, (Object)excludeAgentMatcher);
        }
        boolean bl = isExcluded = excludeUrlMatcher != null || excludeAgentMatcher != null;
        if (!isExcluded) {
            logger.trace("No matcher found for excluding this request with request-path: {} and User-Agent: {}", (Object)requestPath, (Object)userAgentHeader);
        }
        return isExcluded;
    }

    private static String getHostname(HttpExchange exchange) {
        Object hostHeader = exchange.getRequestHeaders().get("Host");
        if (hostHeader != null) {
            String port;
            String hostname = (String)hostHeader.get(0);
            int idx = hostname.lastIndexOf(58);
            if (idx > 0 && idx + 1 + (port = String.valueOf(exchange.getLocalAddress().getPort())).length() == hostname.length() && hostname.endsWith(port)) {
                hostname = hostname.substring(0, idx);
            }
            return hostname;
        }
        return exchange.getLocalAddress().getAddress().getHostName();
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
    public static void onExitHandle(@Advice.Argument(value=0) HttpExchange exchange, @Advice.Enter @Nullable Object transactionOrNull, @Advice.Thrown @Nullable Throwable t) {
        Headers headers;
        if (transactionOrNull == null) {
            return;
        }
        Transaction transaction = (Transaction)transactionOrNull;
        transaction.withResultIfUnset(ResultUtil.getResultByHttpStatus(exchange.getResponseCode())).captureException(t);
        Response response = transaction.getContext().getResponse();
        response.withFinished(true).withStatusCode(exchange.getResponseCode());
        ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
        if (transaction.isSampled() && tracer.getConfig(CoreConfiguration.class).isCaptureHeaders() && (headers = exchange.getResponseHeaders()) != null) {
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                response.addHeader(header.getKey(), (Collection<String>)header.getValue());
            }
        }
        ((Transaction)transaction.deactivate()).end();
    }
}

