/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.httpclient.HttpClientAdviceHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;

public class HttpClientAdvice {
    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
    public static Object onBeforeExecute(@Advice.Argument(value=0) HttpRequest httpRequest) {
        return HttpClientAdviceHelper.startSpan(httpRequest);
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
    public static void onAfterExecute(@Advice.Return @Nullable HttpResponse<?> response, @Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) {
        if (spanObj instanceof Span) {
            Span span = (Span)spanObj;
            if (response != null) {
                int statusCode = response.statusCode();
                span.getContext().getHttp().withStatusCode(statusCode);
            }
            ((Span)((Span)span.captureException(t)).deactivate()).end();
        }
    }
}

