/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.GrpcHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import io.grpc.ClientCall;
import io.grpc.Status;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ClientCallListenerInstrumentation
extends BaseInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.any();
    }

    public static class OtherListenerMethod
    extends ClientCallListenerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("onMessage").or(ElementMatchers.named("onHeaders")).or(ElementMatchers.named("onReady"));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.grpc.ClientCallListenerInstrumentation$OtherListenerMethod$OtherMethodAdvice";
        }

        public static class OtherMethodAdvice {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.This ClientCall.Listener<?> listener) {
                return GrpcHelper.getInstance().enterClientListenerMethod(listener);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.This ClientCall.Listener<?> listener, @Advice.Thrown @Nullable Throwable thrown, @Advice.Enter @Nullable Object span) {
                GrpcHelper.getInstance().exitClientListenerMethod(thrown, listener, (Span)span, null);
            }
        }
    }

    public static class Close
    extends ClientCallListenerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("onClose");
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.grpc.ClientCallListenerInstrumentation$Close$CloseAdvice";
        }

        public static class CloseAdvice {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.This ClientCall.Listener<?> listener) {
                return GrpcHelper.getInstance().enterClientListenerMethod(listener);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.This ClientCall.Listener<?> listener, @Advice.Argument(value=0) Status status, @Advice.Thrown @Nullable Throwable thrown, @Advice.Enter @Nullable Object span) {
                GrpcHelper.getInstance().exitClientListenerMethod(thrown, listener, (Span)span, status);
            }
        }
    }
}

