/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.validation;

import javax.annotation.Nullable;
import org.stagemonitor.configuration.ConfigurationOption;

public class RangeValidator<T extends Comparable>
implements ConfigurationOption.Validator<T> {
    @Nullable
    private final T min;
    @Nullable
    private final T max;
    private final boolean mustBeInRange;

    private RangeValidator(@Nullable T min, @Nullable T max, boolean mustBeInRange) {
        this.min = min;
        this.max = max;
        this.mustBeInRange = mustBeInRange;
    }

    public static <T extends Comparable> RangeValidator<T> isInRange(T min, T max) {
        return new RangeValidator<T>(min, max, true);
    }

    public static <T extends Comparable> RangeValidator<T> isNotInRange(T min, T max) {
        return new RangeValidator<T>(min, max, false);
    }

    public static <T extends Comparable> RangeValidator<T> min(T min) {
        return new RangeValidator<Object>(min, null, true);
    }

    public static <T extends Comparable> RangeValidator<T> max(T max) {
        return new RangeValidator<Object>(null, max, true);
    }

    @Override
    public void assertValid(@Nullable T value) {
        if (value != null) {
            boolean isInRange = true;
            if (this.min != null) {
                boolean bl = isInRange = this.min.compareTo(value) <= 0;
            }
            if (this.max != null) {
                isInRange &= value.compareTo(this.max) <= 0;
            }
            if (!isInRange && this.mustBeInRange) {
                throw new IllegalArgumentException(value + " must be in the range [" + this.min + "," + this.max + "]");
            }
            if (isInRange && !this.mustBeInRange) {
                throw new IllegalArgumentException(value + " must not be in the range [" + this.min + "," + this.max + "]");
            }
        }
    }
}

