/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcherValueConverter;
import java.util.Collections;
import java.util.List;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;
import org.stagemonitor.configuration.converter.ListValueConverter;

public class MessagingConfiguration
extends ConfigurationOptionProvider {
    private static final String MESSAGING_CATEGORY = "Messaging";
    private static final String MESSAGE_POLLING_TRANSACTION_STRATEGY = "message_polling_transaction_strategy";
    private ConfigurationOption<Strategy> messagePollingTransactionStrategy = ConfigurationOption.enumOption(Strategy.class).key("message_polling_transaction_strategy").configurationCategory("Messaging").tags("internal").description("Determines whether the agent should create transactions for the polling action itself (e.g. `javax.jms.MessageConsumer#receive`), \nattempt to create a transaction for the message handling code occurring if the polling method returns a message, \nor both. Valid options are: `POLLING`, `HANDLING` and `BOTH`. \n\nThis option is case-insensitive and is only relevant for JMS.").dynamic(true).buildWithDefault(Strategy.HANDLING);
    private ConfigurationOption<Boolean> collectQueueAddress = ConfigurationOption.booleanOption().key("collect_queue_address").configurationCategory("Messaging").tags("internal").description("Determines whether the agent should collect destination address and port, as this may be \nan expensive operation.").dynamic(true).buildWithDefault(Boolean.TRUE);
    private final ConfigurationOption<List<WildcardMatcher>> ignoreMessageQueues = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("ignore_message_queues").configurationCategory("Messaging").description("Used to filter out specific messaging queues/topics from being traced. \n\nThis property should be set to an array containing one or more strings.\nWhen set, sends-to and receives-from the specified queues/topic will be ignored.\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<Boolean> endMessagingTransactionOnPoll = ConfigurationOption.booleanOption().key("end_messaging_transaction_on_poll").configurationCategory("Messaging").tags("internal").description("When tracing messaging systems, we sometimes create transactions based on consumed messages \nwhen they are iterated-over after being polled. This means that transaction ending relies on the \niterating behavior, which means transactions may be left unclosed. In such cases, we deactivate \nand close such transactions when the next poll action is invoked on the same thread. \nHowever, if the messaging transaction itself tries to poll a queue, it will be ended prematurely. In \nsuch cases, set this property to false.This option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Boolean.TRUE);

    public Strategy getMessagePollingTransactionStrategy() {
        return this.messagePollingTransactionStrategy.get();
    }

    public List<WildcardMatcher> getIgnoreMessageQueues() {
        return this.ignoreMessageQueues.get();
    }

    public boolean shouldCollectQueueAddress() {
        return this.collectQueueAddress.get();
    }

    public boolean shouldEndMessagingTransactionOnPoll() {
        return this.endMessagingTransactionOnPoll.get();
    }

    public static enum Strategy {
        POLLING,
        HANDLING,
        BOTH;

    }
}

