/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.collections;

import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeakMapCleaner
extends AbstractLifecycleListener
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WeakMapCleaner.class);
    private final ScheduledThreadPoolExecutor scheduler = ExecutorUtils.createSingleThreadSchedulingDaemonPool("weak-map-cleaner");

    @Override
    public void start(ElasticApmTracer tracer) {
        this.scheduler.scheduleWithFixedDelay(this, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() throws Exception {
        this.scheduler.shutdownNow();
        this.scheduler.awaitTermination(1L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        try {
            WeakConcurrentProviderImpl.expungeStaleEntries();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }
}

