/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.classloading;

import co.elastic.apm.agent.bci.classloading.DiscriminatingMultiParentClassLoader;
import java.net.URL;
import java.util.Map;
import javax.annotation.Nullable;
import net.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class IndyPluginClassLoader
extends ByteArrayClassLoader.ChildFirst {
    private static final ClassLoader SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();

    public IndyPluginClassLoader(@Nullable ClassLoader targetClassLoader, ClassLoader agentClassLoader, Map<String, byte[]> typeDefinitions) {
        super(IndyPluginClassLoader.getParent(targetClassLoader, agentClassLoader), true, typeDefinitions, ByteArrayClassLoader.PersistenceHandler.LATENT);
    }

    private static ClassLoader getParent(@Nullable ClassLoader targetClassLoader, ClassLoader agentClassLoader) {
        if (targetClassLoader == null) {
            return agentClassLoader;
        }
        if (agentClassLoader == SYSTEM_CLASS_LOADER) {
            return new DiscriminatingMultiParentClassLoader(agentClassLoader, IndyPluginClassLoader.startsWith("co.elastic.apm.agent").or(IndyPluginClassLoader.startsWith("net.bytebuddy")), targetClassLoader, ElementMatchers.any());
        }
        return new DiscriminatingMultiParentClassLoader(agentClassLoader, ElementMatchers.not(IndyPluginClassLoader.startsWith("org.apache.logging.log4j")), targetClassLoader, ElementMatchers.any());
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        return url != null ? url : this.getParent().getResource(name);
    }

    public static StartsWithElementMatcher startsWith(String prefix) {
        return new StartsWithElementMatcher(prefix);
    }

    private static class StartsWithElementMatcher
    extends ElementMatcher.Junction.AbstractBase<String> {
        private final String prefix;

        private StartsWithElementMatcher(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean matches(String s) {
            return s.startsWith(this.prefix);
        }
    }
}

