/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaModule;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;

public class PatchBytecodeVersionTo51Transformer
implements AgentBuilder.Transformer {
    private static boolean isAtLeastJava7(TypeDescription typeDescription) {
        ClassFileVersion classFileVersion = typeDescription.getClassFileVersion();
        return classFileVersion != null && classFileVersion.getJavaVersion() >= 7;
    }

    @Override
    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule) {
        if (PatchBytecodeVersionTo51Transformer.isAtLeastJava7(typeDescription)) {
            return builder;
        }
        return builder.visit(new AsmVisitorWrapper.AbstractBase(){

            @Override
            public ClassVisitor wrap(TypeDescription typeDescription, ClassVisitor classVisitor, Implementation.Context context, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fieldList, MethodList<?> methodList, int writerFlags, int readerFlags) {
                return new ClassVisitor(458752, classVisitor){
                    private boolean patchVersion;

                    @Override
                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        if (version < 51) {
                            this.patchVersion = true;
                            version = 51;
                        }
                        super.visit(version, access, name, signature, superName, interfaces);
                    }

                    @Override
                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                        if (this.patchVersion) {
                            return new JSRInlinerAdapter(methodVisitor, access, name, descriptor, signature, exceptions);
                        }
                        return methodVisitor;
                    }
                };
            }

            @Override
            public int mergeWriter(int flags) {
                return flags | 2;
            }
        });
    }
}

