/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.configuration.converter.ByteValue;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.util.ExecutorUtils;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EntryWeigher;
import java.lang.management.ManagementFactory;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.pool.TypePool;

public class LruTypePoolCache
extends AgentBuilder.PoolStrategy.WithTypePoolCache {
    static final int AVERAGE_SIZE_OF_TYPE_RESOLUTION = (int)ByteValue.of("16kb").getBytes();
    private static final int DEFAULT_MIN_CACHE_SIZE = (int)ByteValue.of("512kb").getBytes() / AVERAGE_SIZE_OF_TYPE_RESOLUTION;
    private static final int DEFAULT_MAX_CACHE_SIZE = (int)ByteValue.of("10mb").getBytes() / AVERAGE_SIZE_OF_TYPE_RESOLUTION;
    private static final double DEFAULT_TARGET_PERCENT_OF_HEAP = 0.01;
    private static final long DEFAULT_STALE_ENTRY_MAX_AGE_MS = TimeUnit.SECONDS.toMillis(60L);
    private final int maxCacheSize;
    private final AtomicReference<SoftReference<ConcurrentMap<String, ResolutionsByClassLoader>>> sharedCache;
    private final WeakMap<ClassLoader, TypePool.CacheProvider> cacheProviders;
    private final ScheduledThreadPoolExecutor executor;

    public LruTypePoolCache(TypePool.Default.ReaderMode readerMode) {
        this(readerMode, LruTypePoolCache.cacheSizeForPercentageOfCommittedHeap(DEFAULT_MIN_CACHE_SIZE, DEFAULT_MAX_CACHE_SIZE, 0.01));
    }

    public LruTypePoolCache(TypePool.Default.ReaderMode readerMode, int maxCacheSize) {
        super(readerMode);
        this.maxCacheSize = maxCacheSize;
        this.sharedCache = new AtomicReference<SoftReference<ConcurrentMap<String, ResolutionsByClassLoader>>>(new SoftReference<ConcurrentMap<String, ResolutionsByClassLoader>>(this.createCache()));
        this.cacheProviders = WeakConcurrent.buildMap();
        this.executor = ExecutorUtils.createSingleThreadSchedulingDaemonPool("type-cache-pool-cleaner");
    }

    public static int cacheSizeForPercentageOfCommittedHeap(int minCacheSize, int maxCacheSize, double targetPercentOfHeap) {
        long maxHeap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getCommitted();
        int cacheSizeForTargetPercentOfHeap = (int)((double)maxHeap * targetPercentOfHeap / (double)AVERAGE_SIZE_OF_TYPE_RESOLUTION);
        int cacheSize = Math.max(minCacheSize, cacheSizeForTargetPercentOfHeap);
        cacheSize = Math.min(maxCacheSize, cacheSize);
        return cacheSize;
    }

    public LruTypePoolCache scheduleEntryEviction() {
        return this.scheduleEntryEviction(DEFAULT_STALE_ENTRY_MAX_AGE_MS);
    }

    public LruTypePoolCache scheduleEntryEviction(final long maxAgeMs) {
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                LruTypePoolCache.this.evictStaleEntries(maxAgeMs);
            }
        }, maxAgeMs, maxAgeMs, TimeUnit.MILLISECONDS);
        return this;
    }

    void evictStaleEntries(long maxAgeMs) {
        long deadline = System.currentTimeMillis() - maxAgeMs;
        Iterator iterator = this.getSharedCache().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((ResolutionsByClassLoader)entry.getValue()).isExpired(deadline)) continue;
            iterator.remove();
        }
    }

    private ConcurrentMap<String, ResolutionsByClassLoader> createCache() {
        return new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(this.maxCacheSize).weigher(new EntryWeigher<String, ResolutionsByClassLoader>(){

            @Override
            public int weightOf(String key, ResolutionsByClassLoader value) {
                return Math.max(1, value.size());
            }
        }).build();
    }

    @Override
    protected TypePool.CacheProvider locate(@Nullable ClassLoader classLoader) {
        TypePool.CacheProvider racy;
        TypePool.CacheProvider cacheProvider;
        if (classLoader == null) {
            classLoader = this.getBootstrapMarkerLoader();
        }
        if ((cacheProvider = this.cacheProviders.get(classLoader)) == null && (racy = this.cacheProviders.putIfAbsent(classLoader, cacheProvider = new GlobalCacheProviderAdapter(new WeakReference<ClassLoader>(classLoader), this))) != null) {
            cacheProvider = racy;
        }
        return cacheProvider;
    }

    private ClassLoader getBootstrapMarkerLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public ConcurrentMap<String, ResolutionsByClassLoader> getSharedCache() {
        SoftReference<ConcurrentMap<String, ResolutionsByClassLoader>> reference = this.sharedCache.get();
        ConcurrentMap<String, ResolutionsByClassLoader> cache = reference.get();
        if (cache == null) {
            cache = this.createCache();
            while (!this.sharedCache.compareAndSet(reference, new SoftReference<ConcurrentMap<String, ResolutionsByClassLoader>>(cache))) {
                reference = this.sharedCache.get();
                ConcurrentMap<String, ResolutionsByClassLoader> previous = reference.get();
                if (previous == null) continue;
                cache = previous;
                break;
            }
        }
        return cache;
    }

    private static class GlobalCacheProviderAdapter
    implements TypePool.CacheProvider {
        private final WeakReference<ClassLoader> classLoader;
        private final LruTypePoolCache cache;

        public GlobalCacheProviderAdapter(WeakReference<ClassLoader> classLoader, LruTypePoolCache cache) {
            this.classLoader = classLoader;
            this.cache = cache;
        }

        @Override
        @Nullable
        public TypePool.Resolution find(String name) {
            ClassLoader key = (ClassLoader)this.classLoader.get();
            ResolutionsByClassLoader resolutionByClassLoader = (ResolutionsByClassLoader)this.cache.getSharedCache().get(name);
            if (key == null || resolutionByClassLoader == null) {
                return null;
            }
            return resolutionByClassLoader.getResolution(key);
        }

        @Override
        public TypePool.Resolution register(String name, TypePool.Resolution resolution) {
            ClassLoader classLoader = (ClassLoader)this.classLoader.get();
            if (classLoader == null) {
                return resolution;
            }
            ConcurrentMap<String, ResolutionsByClassLoader> cache = this.cache.getSharedCache();
            ResolutionsByClassLoader resolutionByClassLoader = this.getOrCreate(name, cache);
            TypePool.Resolution racy = resolutionByClassLoader.addResolution(classLoader, resolution);
            if (racy != null) {
                resolution = racy;
            }
            cache.replace(name, resolutionByClassLoader);
            return resolution;
        }

        private ResolutionsByClassLoader getOrCreate(String name, ConcurrentMap<String, ResolutionsByClassLoader> cache) {
            ResolutionsByClassLoader racy;
            ResolutionsByClassLoader resolutionByClassLoader = (ResolutionsByClassLoader)cache.get(name);
            if (resolutionByClassLoader == null && (racy = cache.putIfAbsent(name, resolutionByClassLoader = new ResolutionsByClassLoader())) != null) {
                resolutionByClassLoader = racy;
            }
            return resolutionByClassLoader;
        }

        @Override
        public void clear() {
        }
    }

    public static class ResolutionsByClassLoader {
        private final AtomicLong lastAccess = new AtomicLong(System.currentTimeMillis());
        private final WeakMap<ClassLoader, TypePool.Resolution> typeByClassLoader = WeakConcurrent.weakMapBuilder().withInitialCapacity(1).build();

        @Nullable
        public TypePool.Resolution getResolution(ClassLoader classLoader) {
            this.lastAccess.set(System.currentTimeMillis());
            return this.typeByClassLoader.get(classLoader);
        }

        @Nullable
        public TypePool.Resolution addResolution(ClassLoader classLoader, TypePool.Resolution resolution) {
            this.lastAccess.set(System.currentTimeMillis());
            return this.typeByClassLoader.putIfAbsent(classLoader, resolution);
        }

        public int size() {
            return this.typeByClassLoader.approximateSize();
        }

        public boolean isExpired(long deadline) {
            return this.lastAccess.get() < deadline;
        }
    }
}

