/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;

public class AnnotationValueOffsetMappingFactory
implements Advice.OffsetMapping.Factory<AnnotationValueExtractor> {
    @Override
    public Class<AnnotationValueExtractor> getAnnotationType() {
        return AnnotationValueExtractor.class;
    }

    @Override
    public Advice.OffsetMapping make(ParameterDescription.InDefinedShape target, final AnnotationDescription.Loadable<AnnotationValueExtractor> annotation, Advice.OffsetMapping.Factory.AdviceType adviceType) {
        return new Advice.OffsetMapping(){

            @Override
            public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
                return Advice.OffsetMapping.Target.ForStackManipulation.of(AnnotationValueOffsetMappingFactory.this.getAnnotationValue(instrumentedMethod, (AnnotationValueExtractor)annotation.load()));
            }
        };
    }

    @Nullable
    private Object getAnnotationValue(MethodDescription instrumentedMethod, AnnotationValueExtractor annotationValueExtractor) {
        MethodDescription methodDescription = instrumentedMethod;
        do {
            for (TypeDescription typeDescription : methodDescription.getDeclaredAnnotations().asTypeList()) {
                if (!ElementMatchers.named(annotationValueExtractor.annotationClassName()).matches(typeDescription)) continue;
                for (MethodDescription.InDefinedShape annotationMethod : typeDescription.getDeclaredMethods()) {
                    if (!annotationMethod.getName().equals(annotationValueExtractor.method())) continue;
                    return methodDescription.getDeclaredAnnotations().ofType(typeDescription).getValue(annotationMethod).resolve();
                }
            }
        } while ((methodDescription = this.findInstrumentedMethodInSuperClass(methodDescription.getDeclaringType().getSuperClass(), instrumentedMethod)) != null);
        return null;
    }

    @Nullable
    private MethodDescription findInstrumentedMethodInSuperClass(@Nullable TypeDescription.Generic superClass, MethodDescription instrumentedMethod) {
        if (superClass == null) {
            return null;
        }
        for (MethodDescription methodDescription : superClass.getDeclaredMethods()) {
            if (!instrumentedMethod.getInternalName().equals(methodDescription.getInternalName()) || !instrumentedMethod.getParameters().asTypeList().asErasures().equals(methodDescription.getParameters().asTypeList().asErasures())) continue;
            return methodDescription;
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface AnnotationValueExtractor {
        public String annotationClassName();

        public String method();
    }
}

