/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.helper.AbstractLambdaTransactionHelper;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.CloudOrigin;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.context.ServiceOrigin;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class AbstractMessageBasedTransactionHelper<I, O, R>
extends AbstractLambdaTransactionHelper<I, O> {
    protected static final String TRANSACTION_TYPE = "messaging";

    protected AbstractMessageBasedTransactionHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    protected abstract TextHeaderGetter<R> getTextHeaderGetter();

    protected abstract String getAWSService();

    @Nullable
    protected abstract String getQueueArn(R var1);

    protected abstract long getMessageTimestampMs(R var1);

    @Nullable
    protected abstract String getBody(R var1);

    @Nullable
    protected abstract String getMessageId(R var1);

    @Nullable
    protected abstract String getRegion(R var1);

    protected abstract Collection<String> getHeaderNames(R var1);

    @Nullable
    protected abstract String getHeaderValue(R var1, String var2);

    @Nullable
    protected abstract String getVersion(R var1);

    protected abstract R getRecord(I var1);

    @Override
    @Nullable
    protected Transaction doStartTransaction(I event, Context lambdaContext) {
        R record = this.getRecord(event);
        Transaction transaction = this.tracer.startChildTransaction(record, this.getTextHeaderGetter(), lambdaContext.getClass().getClassLoader());
        if (null != transaction) {
            Message messageCtx = transaction.getContext().getMessage();
            long messageTimestampMs = this.getMessageTimestampMs(record);
            long transactionTimestampMs = transaction.getTimestamp() / 1000L;
            if (messageTimestampMs > 0L && transactionTimestampMs > messageTimestampMs) {
                messageCtx.withAge(transactionTimestampMs - messageTimestampMs);
            }
            if (this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF) {
                messageCtx.withBody(this.getBody(record));
            }
            if (this.coreConfiguration.isCaptureHeaders()) {
                for (String headerName : this.getHeaderNames(record)) {
                    messageCtx.addHeader(headerName, this.getHeaderValue(record, headerName));
                }
            }
        }
        return transaction;
    }

    @Override
    public void captureOutputForTransaction(Transaction transaction, O output) {
    }

    @Override
    protected void setTransactionTriggerData(Transaction transaction, I event) {
        R record = this.getRecord(event);
        transaction.withType(TRANSACTION_TYPE);
        transaction.getFaas().getTrigger().withType("pubsub").withRequestId(this.getMessageId(record));
        ServiceOrigin serviceOrigin = transaction.getContext().getServiceOrigin();
        CloudOrigin cloudOrigin = transaction.getContext().getCloudOrigin();
        cloudOrigin.withProvider("aws");
        cloudOrigin.withServiceName(this.getAWSService());
        String region = this.getRegion(record);
        String queueArn = this.getQueueArn(record);
        if (null != queueArn) {
            String queueName = null;
            String accountId = null;
            String[] arnSegments = queueArn.split(":", -1);
            if (arnSegments.length >= 6) {
                queueName = arnSegments[5].isEmpty() ? null : arnSegments[5];
                String string = accountId = arnSegments[4].isEmpty() ? null : arnSegments[4];
                if (region == null && !arnSegments[3].isEmpty()) {
                    region = arnSegments[3];
                }
            }
            this.updateTransactionName(transaction, queueName);
            transaction.getContext().getMessage().withQueue(queueName);
            serviceOrigin.withId(queueArn);
            serviceOrigin.withName(queueName);
            String serviceOriginVersion = this.getVersion(record);
            if (null != serviceOriginVersion) {
                serviceOrigin.withVersion(serviceOriginVersion);
            }
            cloudOrigin.withAccountId(accountId);
            if (null != region) {
                cloudOrigin.withRegion(region);
            }
        }
    }

    private void updateTransactionName(Transaction transaction, @Nullable String queueName) {
        StringBuilder transactionName = transaction.getAndOverrideName(100);
        if (null != transactionName && null != queueName && !queueName.isEmpty()) {
            transactionName.append("RECEIVE ").append(queueName);
        }
    }
}

