/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.MapTextHeaderGetter;
import co.elastic.apm.agent.awslambda.helper.AbstractAPIGatewayTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import java.util.Map;
import javax.annotation.Nullable;

public class APIGatewayProxyV1TransactionHelper
extends AbstractAPIGatewayTransactionHelper<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> {
    @Nullable
    private static APIGatewayProxyV1TransactionHelper INSTANCE;

    private APIGatewayProxyV1TransactionHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    public static APIGatewayProxyV1TransactionHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new APIGatewayProxyV1TransactionHelper(GlobalTracer.requireTracerImpl());
        }
        return INSTANCE;
    }

    @Override
    protected Transaction doStartTransaction(APIGatewayProxyRequestEvent apiGatewayEvent, Context lambdaContext) {
        Transaction transaction = this.tracer.startChildTransaction(apiGatewayEvent.getHeaders(), MapTextHeaderGetter.INSTANCE, apiGatewayEvent.getClass().getClassLoader());
        String host = null;
        if (null != apiGatewayEvent.getHeaders() && null == (host = (String)apiGatewayEvent.getHeaders().get("host"))) {
            host = (String)apiGatewayEvent.getHeaders().get("Host");
        }
        if (null != transaction) {
            this.fillHttpRequestData(transaction, apiGatewayEvent.getHttpMethod(), apiGatewayEvent.getHeaders(), host, apiGatewayEvent.getPath(), this.getQueryString(apiGatewayEvent), apiGatewayEvent.getBody());
        }
        return transaction;
    }

    @Nullable
    private String getQueryString(APIGatewayProxyRequestEvent apiGatewayEvent) {
        Map queryParameters = apiGatewayEvent.getQueryStringParameters();
        if (null != queryParameters && !queryParameters.isEmpty()) {
            StringBuilder queryString = new StringBuilder();
            int i = 0;
            for (Map.Entry entry : apiGatewayEvent.getQueryStringParameters().entrySet()) {
                if (i > 0) {
                    queryString.append('&');
                }
                queryString.append((String)entry.getKey());
                queryString.append('=');
                queryString.append((String)entry.getValue());
                ++i;
            }
            return queryString.toString();
        }
        return null;
    }

    @Override
    public void captureOutputForTransaction(Transaction transaction, APIGatewayProxyResponseEvent responseEvent) {
        this.fillHttpResponseData(transaction, responseEvent.getHeaders(), responseEvent.getStatusCode());
    }

    @Override
    protected void setTransactionTriggerData(Transaction transaction, APIGatewayProxyRequestEvent apiGatewayRequest) {
        super.setTransactionTriggerData(transaction, apiGatewayRequest);
        APIGatewayProxyRequestEvent.ProxyRequestContext rContext = apiGatewayRequest.getRequestContext();
        if (null != rContext) {
            this.setApiGatewayContextData(transaction, rContext.getRequestId(), rContext.getApiId(), rContext.getHttpMethod(), rContext.getResourcePath(), rContext.getAccountId());
        }
    }

    @Override
    protected String getHttpMethod(APIGatewayProxyRequestEvent event) {
        return event.getHttpMethod();
    }

    @Override
    protected String getApiGatewayVersion() {
        return "1.0";
    }
}

